/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Credential response object for enrolled credential details, along with enrollment and key identifiers to associate the credential")
@JsonPropertyOrder(value={"authenticatorEnrollmentId", "credResponseJWE"})
public class WebAuthnCredResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID = "authenticatorEnrollmentId";
    private String authenticatorEnrollmentId;
    public static final String JSON_PROPERTY_CRED_RESPONSE_J_W_E = "credResponseJWE";
    private String credResponseJWE;

    public WebAuthnCredResponse authenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID for a WebAuthn Preregistration Factor in Okta")
    @JsonProperty(value="authenticatorEnrollmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthenticatorEnrollmentId() {
        return this.authenticatorEnrollmentId;
    }

    @JsonProperty(value="authenticatorEnrollmentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
    }

    public WebAuthnCredResponse credResponseJWE(String credResponseJWE) {
        this.credResponseJWE = credResponseJWE;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Encrypted JWE of credential response from the fulfillment provider")
    @JsonProperty(value="credResponseJWE")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCredResponseJWE() {
        return this.credResponseJWE;
    }

    @JsonProperty(value="credResponseJWE")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredResponseJWE(String credResponseJWE) {
        this.credResponseJWE = credResponseJWE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnCredResponse webAuthnCredResponse = (WebAuthnCredResponse)o;
        return Objects.equals(this.authenticatorEnrollmentId, webAuthnCredResponse.authenticatorEnrollmentId) && Objects.equals(this.credResponseJWE, webAuthnCredResponse.credResponseJWE);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorEnrollmentId, this.credResponseJWE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAuthnCredResponse {\n");
        sb.append("    authenticatorEnrollmentId: ").append(this.toIndentedString(this.authenticatorEnrollmentId)).append("\n");
        sb.append("    credResponseJWE: ").append(this.toIndentedString(this.credResponseJWE)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

