/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationApi {

    private ApiClient apiClient;

    public ApplicationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate an Application Activates an inactive application
     *
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateApplication(String appId) throws ApiException {
        this.activateApplication(appId, Collections.emptyMap());
    }

    /**
     * Activate an Application Activates an inactive application
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling activateApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/lifecycle/activate".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Create an Application Creates an app instance in your Okta org. You can either create an OIN app instance or a
     * custom app instance: * OIN app instances have prescribed &#x60;name&#x60; (key app definition) and
     * &#x60;signOnMode&#x60; options. See the [OIN
     * schemas](/openapi/okta-management/management/tag/Application/#tag/Application/schema/GoogleApplication) for the
     * request body. * For custom app instances, select the
     * [signOnMode](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication!path&#x3D;0/signOnMode&amp;t&#x3D;request)
     * that pertains to your app and specify the required parameters in the request body.
     *
     * @param application
     *            (required)
     * @param activate
     *            Executes activation lifecycle operation when creating the app (optional, default to true)
     * @param oktaAccessGatewayAgent
     *            (optional)
     *
     * @return Application
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent)
            throws ApiException {
        return this.createApplication(application, activate, oktaAccessGatewayAgent, Collections.emptyMap());
    }

    /**
     * Create an Application Creates an app instance in your Okta org. You can either create an OIN app instance or a
     * custom app instance: * OIN app instances have prescribed &#x60;name&#x60; (key app definition) and
     * &#x60;signOnMode&#x60; options. See the [OIN
     * schemas](/openapi/okta-management/management/tag/Application/#tag/Application/schema/GoogleApplication) for the
     * request body. * For custom app instances, select the
     * [signOnMode](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication!path&#x3D;0/signOnMode&amp;t&#x3D;request)
     * that pertains to your app and specify the required parameters in the request body.
     *
     * @param application
     *            (required)
     * @param activate
     *            Executes activation lifecycle operation when creating the app (optional, default to true)
     * @param oktaAccessGatewayAgent
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Application
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = application;

        // verify the required parameter 'application' is set
        if (application == null) {
            throw new ApiException(400, "Missing the required parameter 'application' when calling createApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("activate", activate));
        if (oktaAccessGatewayAgent != null)
            localVarHeaderParams.put("OktaAccessGateway-Agent", apiClient.parameterToString(oktaAccessGatewayAgent));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Application> localVarReturnType = new TypeReference<Application>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an Application Deactivates an active application
     *
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateApplication(String appId) throws ApiException {
        this.deactivateApplication(appId, Collections.emptyMap());
    }

    /**
     * Deactivate an Application Deactivates an active application
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deactivateApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/lifecycle/deactivate".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete an Application Deletes an inactive application
     *
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteApplication(String appId) throws ApiException {
        this.deleteApplication(appId, Collections.emptyMap());
    }

    /**
     * Delete an Application Deletes an inactive application
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an Application Retrieves an application from your Okta organization by &#x60;id&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param expand
     *            An optional query parameter to return the specified [Application
     *            User](/openapi/okta-management/management/tag/ApplicationUsers/) in the &#x60;_embedded&#x60;
     *            property. Valid value: &#x60;expand&#x3D;user/{userId}&#x60; (optional)
     *
     * @return Application
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Application getApplication(String appId, String expand) throws ApiException {
        return this.getApplication(appId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve an Application Retrieves an application from your Okta organization by &#x60;id&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param expand
     *            An optional query parameter to return the specified [Application
     *            User](/openapi/okta-management/management/tag/ApplicationUsers/) in the &#x60;_embedded&#x60;
     *            property. Valid value: &#x60;expand&#x3D;user/{userId}&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Application
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Application getApplication(String appId, String expand, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Application> localVarReturnType = new TypeReference<Application>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Applications Lists all apps in the org with pagination. A subset of apps can be returned that match a
     * supported filter expression or query. The results are [paginated](/#pagination) according to the
     * &#x60;limit&#x60; parameter. If there are multiple pages of results, the header contains a &#x60;next&#x60; link.
     * Treat the link as an opaque value (follow it, don&#39;t parse it).
     *
     * @param q
     *            Searches for apps with &#x60;name&#x60; or &#x60;label&#x60; properties that starts with the
     *            &#x60;q&#x60; value using the &#x60;startsWith&#x60; operation (optional)
     * @param after
     *            Specifies the [pagination](/#pagination) cursor for the next page of results. Treat this as an opaque
     *            value obtained through the &#x60;next&#x60; link relationship. (optional)
     * @param useOptimization
     *            Specifies whether to use query optimization. If you specify &#x60;useOptimization&#x3D;true&#x60; in
     *            the request query, the response contains a subset of app instance properties. (optional, default to
     *            false)
     * @param limit
     *            Specifies the number of results per page (optional, default to -1)
     * @param filter
     *            Filters apps by &#x60;status&#x60;, &#x60;user.id&#x60;, &#x60;group.id&#x60;,
     *            &#x60;credentials.signing.kid&#x60; or &#x60;name&#x60; expression that supports the &#x60;eq&#x60;
     *            operator (optional)
     * @param expand
     *            An optional parameter used for link expansion to embed more resources in the response. Only supports
     *            &#x60;expand&#x3D;user/{userId}&#x60; and must be used with the &#x60;user.id eq
     *            \&quot;{userId}\&quot;&#x60; filter query for the same user. Returns the assigned [Application
     *            User](/openapi/okta-management/management/tag/ApplicationUsers/) in the &#x60;_embedded&#x60;
     *            property. (optional)
     * @param includeNonDeleted
     *            Specifies whether to include non-active, but not deleted apps in the results (optional, default to
     *            false)
     *
     * @return List&lt;Application&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Application> listApplications(String q, String after, Boolean useOptimization, Integer limit,
            String filter, String expand, Boolean includeNonDeleted) throws ApiException {
        return this.listApplications(q, after, useOptimization, limit, filter, expand, includeNonDeleted,
                Collections.emptyMap());
    }

    /**
     * List all Applications Lists all apps in the org with pagination. A subset of apps can be returned that match a
     * supported filter expression or query. The results are [paginated](/#pagination) according to the
     * &#x60;limit&#x60; parameter. If there are multiple pages of results, the header contains a &#x60;next&#x60; link.
     * Treat the link as an opaque value (follow it, don&#39;t parse it).
     *
     * @param q
     *            Searches for apps with &#x60;name&#x60; or &#x60;label&#x60; properties that starts with the
     *            &#x60;q&#x60; value using the &#x60;startsWith&#x60; operation (optional)
     * @param after
     *            Specifies the [pagination](/#pagination) cursor for the next page of results. Treat this as an opaque
     *            value obtained through the &#x60;next&#x60; link relationship. (optional)
     * @param useOptimization
     *            Specifies whether to use query optimization. If you specify &#x60;useOptimization&#x3D;true&#x60; in
     *            the request query, the response contains a subset of app instance properties. (optional, default to
     *            false)
     * @param limit
     *            Specifies the number of results per page (optional, default to -1)
     * @param filter
     *            Filters apps by &#x60;status&#x60;, &#x60;user.id&#x60;, &#x60;group.id&#x60;,
     *            &#x60;credentials.signing.kid&#x60; or &#x60;name&#x60; expression that supports the &#x60;eq&#x60;
     *            operator (optional)
     * @param expand
     *            An optional parameter used for link expansion to embed more resources in the response. Only supports
     *            &#x60;expand&#x3D;user/{userId}&#x60; and must be used with the &#x60;user.id eq
     *            \&quot;{userId}\&quot;&#x60; filter query for the same user. Returns the assigned [Application
     *            User](/openapi/okta-management/management/tag/ApplicationUsers/) in the &#x60;_embedded&#x60;
     *            property. (optional)
     * @param includeNonDeleted
     *            Specifies whether to include non-active, but not deleted apps in the results (optional, default to
     *            false)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Application&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Application> listApplications(String q, String after, Boolean useOptimization, Integer limit,
            String filter, String expand, Boolean includeNonDeleted, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/apps";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("useOptimization", useOptimization));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("includeNonDeleted", includeNonDeleted));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Application>> localVarReturnType = new TypeReference<List<Application>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an Application Replaces properties for an application &gt; **Notes:** &gt; * All required properties must
     * be specified in the request body &gt; * You can&#39;t modify system-assigned properties, such as &#x60;id&#x60;,
     * &#x60;name&#x60;, &#x60;status&#x60;, &#x60;created&#x60;, and &#x60;lastUpdated&#x60;. The values for these
     * properties in the PUT request body are ignored.
     *
     * @param appId
     *            Application ID (required)
     * @param application
     *            (required)
     *
     * @return Application
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Application replaceApplication(String appId, Application application) throws ApiException {
        return this.replaceApplication(appId, application, Collections.emptyMap());
    }

    /**
     * Replace an Application Replaces properties for an application &gt; **Notes:** &gt; * All required properties must
     * be specified in the request body &gt; * You can&#39;t modify system-assigned properties, such as &#x60;id&#x60;,
     * &#x60;name&#x60;, &#x60;status&#x60;, &#x60;created&#x60;, and &#x60;lastUpdated&#x60;. The values for these
     * properties in the PUT request body are ignored.
     *
     * @param appId
     *            Application ID (required)
     * @param application
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Application
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Application replaceApplication(String appId, Application application, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = application;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling replaceApplication");
        }

        // verify the required parameter 'application' is set
        if (application == null) {
            throw new ApiException(400, "Missing the required parameter 'application' when calling replaceApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Application> localVarReturnType = new TypeReference<Application>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
