/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuth2ClientJsonWebKey;
import com.okta.sdk.resource.model.OAuth2ClientJsonWebKeyRequestBody;
import com.okta.sdk.resource.model.OAuth2ClientSecret;
import com.okta.sdk.resource.model.OAuth2ClientSecretRequestBody;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationSsoCredentialOAuth2ClientAuthApi {

    private ApiClient apiClient;

    public ApplicationSsoCredentialOAuth2ClientAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationSsoCredentialOAuth2ClientAuthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate an OAuth 2.0 Client JSON Web Key Activates an OAuth 2.0 Client JSON Web Key by &#x60;keyId&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client JSON Web Key (required)
     *
     * @return OAuth2ClientJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientJsonWebKey activateOAuth2ClientJsonWebKey(String appId, String keyId) throws ApiException {
        return this.activateOAuth2ClientJsonWebKey(appId, keyId, Collections.emptyMap());
    }

    /**
     * Activate an OAuth 2.0 Client JSON Web Key Activates an OAuth 2.0 Client JSON Web Key by &#x60;keyId&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client JSON Web Key (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ClientJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientJsonWebKey activateOAuth2ClientJsonWebKey(String appId, String keyId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling activateOAuth2ClientJsonWebKey");
        }

        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'keyId' when calling activateOAuth2ClientJsonWebKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/jwks/{keyId}/lifecycle/activate"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ClientJsonWebKey> localVarReturnType = new TypeReference<OAuth2ClientJsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Activate an OAuth 2.0 Client Secret Activates an OAuth 2.0 Client Secret by &#x60;secretId&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param secretId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client Secret (required)
     *
     * @return OAuth2ClientSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientSecret activateOAuth2ClientSecret(String appId, String secretId) throws ApiException {
        return this.activateOAuth2ClientSecret(appId, secretId, Collections.emptyMap());
    }

    /**
     * Activate an OAuth 2.0 Client Secret Activates an OAuth 2.0 Client Secret by &#x60;secretId&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param secretId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client Secret (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ClientSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientSecret activateOAuth2ClientSecret(String appId, String secretId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling activateOAuth2ClientSecret");
        }

        // verify the required parameter 'secretId' is set
        if (secretId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'secretId' when calling activateOAuth2ClientSecret");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/secrets/{secretId}/lifecycle/activate"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "secretId" + "\\}", apiClient.escapeString(secretId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ClientSecret> localVarReturnType = new TypeReference<OAuth2ClientSecret>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add a JSON Web Key Adds a new JSON Web Key to the client’s JSON Web Keys. &gt; **Note:** This API doesn&#39;t
     * allow you to add a key if the existing key doesn&#39;t have a &#x60;kid&#x60;. This is also consistent with how
     * the [Dynamic Client Registration](/openapi/okta-oauth/oauth/tag/Client/) or
     * [Applications](/openapi/okta-management/management/tag/Application/) APIs behave, as they don&#39;t allow the
     * creation of multiple keys without &#x60;kids&#x60;. Use the [Replace an
     * Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication)
     * or the [Replace a Client Application](/openapi/okta-oauth/oauth/tag/Client/#tag/Client/operation/replaceClient)
     * operation to update the JWKS or [Delete an OAuth 2.0 Client JSON Web
     * Key](/openapi/okta-management/management/tag/ApplicationSSOCredentialOAuth2ClientAuth/#tag/ApplicationSSOCredentialOAuth2ClientAuth/operation/deletejwk)
     * and re-add the key with a &#x60;kid&#x60;.
     *
     * @param appId
     *            Application ID (required)
     * @param oauth2ClientJsonWebKeyRequestBody
     *            (required)
     *
     * @return OAuth2ClientJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientJsonWebKey addJwk(String appId,
            OAuth2ClientJsonWebKeyRequestBody oauth2ClientJsonWebKeyRequestBody) throws ApiException {
        return this.addJwk(appId, oauth2ClientJsonWebKeyRequestBody, Collections.emptyMap());
    }

    /**
     * Add a JSON Web Key Adds a new JSON Web Key to the client’s JSON Web Keys. &gt; **Note:** This API doesn&#39;t
     * allow you to add a key if the existing key doesn&#39;t have a &#x60;kid&#x60;. This is also consistent with how
     * the [Dynamic Client Registration](/openapi/okta-oauth/oauth/tag/Client/) or
     * [Applications](/openapi/okta-management/management/tag/Application/) APIs behave, as they don&#39;t allow the
     * creation of multiple keys without &#x60;kids&#x60;. Use the [Replace an
     * Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/replaceApplication)
     * or the [Replace a Client Application](/openapi/okta-oauth/oauth/tag/Client/#tag/Client/operation/replaceClient)
     * operation to update the JWKS or [Delete an OAuth 2.0 Client JSON Web
     * Key](/openapi/okta-management/management/tag/ApplicationSSOCredentialOAuth2ClientAuth/#tag/ApplicationSSOCredentialOAuth2ClientAuth/operation/deletejwk)
     * and re-add the key with a &#x60;kid&#x60;.
     *
     * @param appId
     *            Application ID (required)
     * @param oauth2ClientJsonWebKeyRequestBody
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ClientJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientJsonWebKey addJwk(String appId,
            OAuth2ClientJsonWebKeyRequestBody oauth2ClientJsonWebKeyRequestBody, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = oauth2ClientJsonWebKeyRequestBody;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling addJwk");
        }

        // verify the required parameter 'oauth2ClientJsonWebKeyRequestBody' is set
        if (oauth2ClientJsonWebKeyRequestBody == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'oauth2ClientJsonWebKeyRequestBody' when calling addJwk");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/jwks".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ClientJsonWebKey> localVarReturnType = new TypeReference<OAuth2ClientJsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an OAuth 2.0 Client Secret Creates an OAuth 2.0 Client Secret object with a new active client secret. You
     * can create up to two Secret objects. An error is returned if you attempt to create more than two Secret objects.
     * &gt; **Note:** This API lets you bring your own secret. If
     * [token_endpoint_auth_method](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication!path&#x3D;4/credentials/oauthClient/token_endpoint_auth_method&amp;t&#x3D;request)
     * of the app is &#x60;client_secret_jwt&#x60;, then the minimum length of &#x60;client_secret&#x60; is 32
     * characters. If no secret is specified in the request, Okta adds a new system-generated secret.
     *
     * @param appId
     *            Application ID (required)
     * @param oauth2ClientSecretRequestBody
     *            (optional)
     *
     * @return OAuth2ClientSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientSecret createOAuth2ClientSecret(String appId,
            OAuth2ClientSecretRequestBody oauth2ClientSecretRequestBody) throws ApiException {
        return this.createOAuth2ClientSecret(appId, oauth2ClientSecretRequestBody, Collections.emptyMap());
    }

    /**
     * Create an OAuth 2.0 Client Secret Creates an OAuth 2.0 Client Secret object with a new active client secret. You
     * can create up to two Secret objects. An error is returned if you attempt to create more than two Secret objects.
     * &gt; **Note:** This API lets you bring your own secret. If
     * [token_endpoint_auth_method](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication!path&#x3D;4/credentials/oauthClient/token_endpoint_auth_method&amp;t&#x3D;request)
     * of the app is &#x60;client_secret_jwt&#x60;, then the minimum length of &#x60;client_secret&#x60; is 32
     * characters. If no secret is specified in the request, Okta adds a new system-generated secret.
     *
     * @param appId
     *            Application ID (required)
     * @param oauth2ClientSecretRequestBody
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ClientSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientSecret createOAuth2ClientSecret(String appId,
            OAuth2ClientSecretRequestBody oauth2ClientSecretRequestBody, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = oauth2ClientSecretRequestBody;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createOAuth2ClientSecret");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/secrets".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ClientSecret> localVarReturnType = new TypeReference<OAuth2ClientSecret>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an OAuth 2.0 Client JSON Web Key Deactivates an OAuth 2.0 Client JSON Web Key by &#x60;keyId&#x60;.
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client JSON Web Key (required)
     *
     * @return OAuth2ClientJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientJsonWebKey deactivateOAuth2ClientJsonWebKey(String appId, String keyId) throws ApiException {
        return this.deactivateOAuth2ClientJsonWebKey(appId, keyId, Collections.emptyMap());
    }

    /**
     * Deactivate an OAuth 2.0 Client JSON Web Key Deactivates an OAuth 2.0 Client JSON Web Key by &#x60;keyId&#x60;.
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client JSON Web Key (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ClientJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientJsonWebKey deactivateOAuth2ClientJsonWebKey(String appId, String keyId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling deactivateOAuth2ClientJsonWebKey");
        }

        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'keyId' when calling deactivateOAuth2ClientJsonWebKey");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/jwks/{keyId}/lifecycle/deactivate"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ClientJsonWebKey> localVarReturnType = new TypeReference<OAuth2ClientJsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an OAuth 2.0 Client Secret Deactivates an OAuth 2.0 Client Secret by &#x60;secretId&#x60;. You
     * can&#39;t deactivate a secret if it&#39;s the only secret of the client.
     *
     * @param appId
     *            Application ID (required)
     * @param secretId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client Secret (required)
     *
     * @return OAuth2ClientSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientSecret deactivateOAuth2ClientSecret(String appId, String secretId) throws ApiException {
        return this.deactivateOAuth2ClientSecret(appId, secretId, Collections.emptyMap());
    }

    /**
     * Deactivate an OAuth 2.0 Client Secret Deactivates an OAuth 2.0 Client Secret by &#x60;secretId&#x60;. You
     * can&#39;t deactivate a secret if it&#39;s the only secret of the client.
     *
     * @param appId
     *            Application ID (required)
     * @param secretId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client Secret (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ClientSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientSecret deactivateOAuth2ClientSecret(String appId, String secretId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling deactivateOAuth2ClientSecret");
        }

        // verify the required parameter 'secretId' is set
        if (secretId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'secretId' when calling deactivateOAuth2ClientSecret");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/secrets/{secretId}/lifecycle/deactivate"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "secretId" + "\\}", apiClient.escapeString(secretId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ClientSecret> localVarReturnType = new TypeReference<OAuth2ClientSecret>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an OAuth 2.0 Client Secret Deletes an OAuth 2.0 Client Secret by &#x60;secretId&#x60;. You can only delete
     * an inactive Secret.
     *
     * @param appId
     *            Application ID (required)
     * @param secretId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client Secret (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteOAuth2ClientSecret(String appId, String secretId) throws ApiException {
        this.deleteOAuth2ClientSecret(appId, secretId, Collections.emptyMap());
    }

    /**
     * Delete an OAuth 2.0 Client Secret Deletes an OAuth 2.0 Client Secret by &#x60;secretId&#x60;. You can only delete
     * an inactive Secret.
     *
     * @param appId
     *            Application ID (required)
     * @param secretId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client Secret (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteOAuth2ClientSecret(String appId, String secretId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteOAuth2ClientSecret");
        }

        // verify the required parameter 'secretId' is set
        if (secretId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'secretId' when calling deleteOAuth2ClientSecret");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/secrets/{secretId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "secretId" + "\\}", apiClient.escapeString(secretId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete an OAuth 2.0 Client JSON Web Key Deletes an OAuth 2.0 Client JSON Web Key by &#x60;keyId&#x60;. You can
     * only delete an inactive key.
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client JSON Web Key (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deletejwk(String appId, String keyId) throws ApiException {
        this.deletejwk(appId, keyId, Collections.emptyMap());
    }

    /**
     * Delete an OAuth 2.0 Client JSON Web Key Deletes an OAuth 2.0 Client JSON Web Key by &#x60;keyId&#x60;. You can
     * only delete an inactive key.
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client JSON Web Key (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deletejwk(String appId, String keyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deletejwk");
        }

        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling deletejwk");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/jwks/{keyId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an OAuth 2.0 Client JSON Web Key Retrieves an OAuth 2.0 Client JSON Web Key by &#x60;keyId&#x60;.
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client JSON Web Key (required)
     *
     * @return OAuth2ClientJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientJsonWebKey getJwk(String appId, String keyId) throws ApiException {
        return this.getJwk(appId, keyId, Collections.emptyMap());
    }

    /**
     * Retrieve an OAuth 2.0 Client JSON Web Key Retrieves an OAuth 2.0 Client JSON Web Key by &#x60;keyId&#x60;.
     *
     * @param appId
     *            Application ID (required)
     * @param keyId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client JSON Web Key (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ClientJsonWebKey
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientJsonWebKey getJwk(String appId, String keyId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getJwk");
        }

        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getJwk");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/jwks/{keyId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "keyId" + "\\}", apiClient.escapeString(keyId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ClientJsonWebKey> localVarReturnType = new TypeReference<OAuth2ClientJsonWebKey>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve an OAuth 2.0 Client Secret Retrieves an OAuth 2.0 Client Secret by &#x60;secretId&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param secretId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client Secret (required)
     *
     * @return OAuth2ClientSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientSecret getOAuth2ClientSecret(String appId, String secretId) throws ApiException {
        return this.getOAuth2ClientSecret(appId, secretId, Collections.emptyMap());
    }

    /**
     * Retrieve an OAuth 2.0 Client Secret Retrieves an OAuth 2.0 Client Secret by &#x60;secretId&#x60;
     *
     * @param appId
     *            Application ID (required)
     * @param secretId
     *            Unique &#x60;id&#x60; of the OAuth 2.0 Client Secret (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ClientSecret
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ClientSecret getOAuth2ClientSecret(String appId, String secretId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getOAuth2ClientSecret");
        }

        // verify the required parameter 'secretId' is set
        if (secretId == null) {
            throw new ApiException(400, "Missing the required parameter 'secretId' when calling getOAuth2ClientSecret");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/secrets/{secretId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "secretId" + "\\}", apiClient.escapeString(secretId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ClientSecret> localVarReturnType = new TypeReference<OAuth2ClientSecret>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all the OAuth 2.0 Client JSON Web Keys Lists all JSON Web Keys for an OAuth 2.0 client app
     *
     * @param appId
     *            Application ID (required)
     *
     * @return List&lt;OAuth2ClientJsonWebKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ClientJsonWebKey> listJwk(String appId) throws ApiException {
        return this.listJwk(appId, Collections.emptyMap());
    }

    /**
     * List all the OAuth 2.0 Client JSON Web Keys Lists all JSON Web Keys for an OAuth 2.0 client app
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2ClientJsonWebKey&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ClientJsonWebKey> listJwk(String appId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listJwk");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/jwks".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2ClientJsonWebKey>> localVarReturnType = new TypeReference<List<OAuth2ClientJsonWebKey>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all OAuth 2.0 Client Secrets Lists all client secrets for an OAuth 2.0 client app
     *
     * @param appId
     *            Application ID (required)
     *
     * @return List&lt;OAuth2ClientSecret&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ClientSecret> listOAuth2ClientSecrets(String appId) throws ApiException {
        return this.listOAuth2ClientSecrets(appId, Collections.emptyMap());
    }

    /**
     * List all OAuth 2.0 Client Secrets Lists all client secrets for an OAuth 2.0 client app
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2ClientSecret&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ClientSecret> listOAuth2ClientSecrets(String appId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listOAuth2ClientSecrets");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/credentials/secrets".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2ClientSecret>> localVarReturnType = new TypeReference<List<OAuth2ClientSecret>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
