/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuth2RefreshToken;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationTokensApi {

    private ApiClient apiClient;

    public ApplicationTokensApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationTokensApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve an Application Token Retrieves a refresh token for the specified app
     *
     * @param appId
     *            Application ID (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param expand
     *            An optional parameter to return scope details in the &#x60;_embedded&#x60; property. Valid value:
     *            &#x60;scope&#x60; (optional)
     *
     * @return OAuth2RefreshToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2RefreshToken getOAuth2TokenForApplication(String appId, String tokenId, String expand)
            throws ApiException {
        return this.getOAuth2TokenForApplication(appId, tokenId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve an Application Token Retrieves a refresh token for the specified app
     *
     * @param appId
     *            Application ID (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param expand
     *            An optional parameter to return scope details in the &#x60;_embedded&#x60; property. Valid value:
     *            &#x60;scope&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2RefreshToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2RefreshToken getOAuth2TokenForApplication(String appId, String tokenId, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling getOAuth2TokenForApplication");
        }

        // verify the required parameter 'tokenId' is set
        if (tokenId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'tokenId' when calling getOAuth2TokenForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/tokens/{tokenId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "tokenId" + "\\}", apiClient.escapeString(tokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2RefreshToken> localVarReturnType = new TypeReference<OAuth2RefreshToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Application Refresh Tokens Lists all refresh tokens for an app &gt; **Note:** The results are
     * [paginated](/#pagination) according to the &#x60;limit&#x60; parameter. &gt; If there are multiple pages of
     * results, the Link header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it,
     * don&#39;t parse it).
     *
     * @param appId
     *            Application ID (required)
     * @param expand
     *            An optional parameter to return scope details in the &#x60;_embedded&#x60; property. Valid value:
     *            &#x60;scope&#x60; (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of results. Treat this as an opaque value obtained
     *            through the next link relationship. See [Pagination](/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     *
     * @return List&lt;OAuth2RefreshToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2RefreshToken> listOAuth2TokensForApplication(String appId, String expand, String after,
            Integer limit) throws ApiException {
        return this.listOAuth2TokensForApplication(appId, expand, after, limit, Collections.emptyMap());
    }

    /**
     * List all Application Refresh Tokens Lists all refresh tokens for an app &gt; **Note:** The results are
     * [paginated](/#pagination) according to the &#x60;limit&#x60; parameter. &gt; If there are multiple pages of
     * results, the Link header contains a &#x60;next&#x60; link that you need to use as an opaque value (follow it,
     * don&#39;t parse it).
     *
     * @param appId
     *            Application ID (required)
     * @param expand
     *            An optional parameter to return scope details in the &#x60;_embedded&#x60; property. Valid value:
     *            &#x60;scope&#x60; (optional)
     * @param after
     *            Specifies the pagination cursor for the next page of results. Treat this as an opaque value obtained
     *            through the next link relationship. See [Pagination](/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2RefreshToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2RefreshToken> listOAuth2TokensForApplication(String appId, String expand, String after,
            Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling listOAuth2TokensForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/tokens".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2RefreshToken>> localVarReturnType = new TypeReference<List<OAuth2RefreshToken>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke an Application Token Revokes the specified token for the specified app
     *
     * @param appId
     *            Application ID (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeOAuth2TokenForApplication(String appId, String tokenId) throws ApiException {
        this.revokeOAuth2TokenForApplication(appId, tokenId, Collections.emptyMap());
    }

    /**
     * Revoke an Application Token Revokes the specified token for the specified app
     *
     * @param appId
     *            Application ID (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeOAuth2TokenForApplication(String appId, String tokenId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling revokeOAuth2TokenForApplication");
        }

        // verify the required parameter 'tokenId' is set
        if (tokenId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'tokenId' when calling revokeOAuth2TokenForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/tokens/{tokenId}"
                .replaceAll("\\{" + "appId" + "\\}", apiClient.escapeString(appId.toString()))
                .replaceAll("\\{" + "tokenId" + "\\}", apiClient.escapeString(tokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Revoke all Application Tokens Revokes all OAuth 2.0 refresh tokens for the specified app. Any access tokens
     * issued with these refresh tokens are also revoked, but access tokens issued without a refresh token aren&#39;t
     * affected.
     *
     * @param appId
     *            Application ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeOAuth2TokensForApplication(String appId) throws ApiException {
        this.revokeOAuth2TokensForApplication(appId, Collections.emptyMap());
    }

    /**
     * Revoke all Application Tokens Revokes all OAuth 2.0 refresh tokens for the specified app. Any access tokens
     * issued with these refresh tokens are also revoked, but access tokens issued without a refresh token aren&#39;t
     * affected.
     *
     * @param appId
     *            Application ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeOAuth2TokensForApplication(String appId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'appId' is set
        if (appId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'appId' when calling revokeOAuth2TokensForApplication");
        }

        // create path and map variables
        String localVarPath = "/api/v1/apps/{appId}/tokens".replaceAll("\\{" + "appId" + "\\}",
                apiClient.escapeString(appId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
