/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.BulkDeleteRequestBody;
import com.okta.sdk.resource.model.BulkUpsertRequestBody;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.IdentitySourceSession;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class IdentitySourceApi {

    private ApiClient apiClient;

    public IdentitySourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentitySourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an Identity Source Session Creates an Identity Source Session for the given Identity Source instance
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     *
     * @return IdentitySourceSession
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentitySourceSession createIdentitySourceSession(String identitySourceId) throws ApiException {
        return this.createIdentitySourceSession(identitySourceId, Collections.emptyMap());
    }

    /**
     * Create an Identity Source Session Creates an Identity Source Session for the given Identity Source instance
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentitySourceSession
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentitySourceSession createIdentitySourceSession(String identitySourceId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'identitySourceId' is set
        if (identitySourceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identitySourceId' when calling createIdentitySourceSession");
        }

        // create path and map variables
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions"
                .replaceAll("\\{" + "identitySourceId" + "\\}", apiClient.escapeString(identitySourceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentitySourceSession> localVarReturnType = new TypeReference<IdentitySourceSession>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an Identity Source Session Deletes an Identity Source Session for a given &#x60;identitySourceId&#x60; and
     * &#x60;sessionId&#x60;
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteIdentitySourceSession(String identitySourceId, String sessionId) throws ApiException {
        this.deleteIdentitySourceSession(identitySourceId, sessionId, Collections.emptyMap());
    }

    /**
     * Delete an Identity Source Session Deletes an Identity Source Session for a given &#x60;identitySourceId&#x60; and
     * &#x60;sessionId&#x60;
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteIdentitySourceSession(String identitySourceId, String sessionId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'identitySourceId' is set
        if (identitySourceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identitySourceId' when calling deleteIdentitySourceSession");
        }

        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'sessionId' when calling deleteIdentitySourceSession");
        }

        // create path and map variables
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}"
                .replaceAll("\\{" + "identitySourceId" + "\\}", apiClient.escapeString(identitySourceId.toString()))
                .replaceAll("\\{" + "sessionId" + "\\}", apiClient.escapeString(sessionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an Identity Source Session Retrieves an Identity Source Session for a given Identity Source ID and
     * session ID
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     *
     * @return IdentitySourceSession
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentitySourceSession getIdentitySourceSession(String identitySourceId, String sessionId)
            throws ApiException {
        return this.getIdentitySourceSession(identitySourceId, sessionId, Collections.emptyMap());
    }

    /**
     * Retrieve an Identity Source Session Retrieves an Identity Source Session for a given Identity Source ID and
     * session ID
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentitySourceSession
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentitySourceSession getIdentitySourceSession(String identitySourceId, String sessionId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'identitySourceId' is set
        if (identitySourceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identitySourceId' when calling getIdentitySourceSession");
        }

        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'sessionId' when calling getIdentitySourceSession");
        }

        // create path and map variables
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}"
                .replaceAll("\\{" + "identitySourceId" + "\\}", apiClient.escapeString(identitySourceId.toString()))
                .replaceAll("\\{" + "sessionId" + "\\}", apiClient.escapeString(sessionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentitySourceSession> localVarReturnType = new TypeReference<IdentitySourceSession>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Identity Source Sessions Lists all Identity Source Sessions for the given Identity Source instance
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     *
     * @return List&lt;IdentitySourceSession&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdentitySourceSession> listIdentitySourceSessions(String identitySourceId) throws ApiException {
        return this.listIdentitySourceSessions(identitySourceId, Collections.emptyMap());
    }

    /**
     * List all Identity Source Sessions Lists all Identity Source Sessions for the given Identity Source instance
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;IdentitySourceSession&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<IdentitySourceSession> listIdentitySourceSessions(String identitySourceId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'identitySourceId' is set
        if (identitySourceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identitySourceId' when calling listIdentitySourceSessions");
        }

        // create path and map variables
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions"
                .replaceAll("\\{" + "identitySourceId" + "\\}", apiClient.escapeString(identitySourceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<IdentitySourceSession>> localVarReturnType = new TypeReference<List<IdentitySourceSession>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Start the import from the Identity Source Starts the import from the Identity Source described by the uploaded
     * bulk operations
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     *
     * @return IdentitySourceSession
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentitySourceSession startImportFromIdentitySource(String identitySourceId, String sessionId)
            throws ApiException {
        return this.startImportFromIdentitySource(identitySourceId, sessionId, Collections.emptyMap());
    }

    /**
     * Start the import from the Identity Source Starts the import from the Identity Source described by the uploaded
     * bulk operations
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IdentitySourceSession
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IdentitySourceSession startImportFromIdentitySource(String identitySourceId, String sessionId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'identitySourceId' is set
        if (identitySourceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identitySourceId' when calling startImportFromIdentitySource");
        }

        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'sessionId' when calling startImportFromIdentitySource");
        }

        // create path and map variables
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/start-import"
                .replaceAll("\\{" + "identitySourceId" + "\\}", apiClient.escapeString(identitySourceId.toString()))
                .replaceAll("\\{" + "sessionId" + "\\}", apiClient.escapeString(sessionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IdentitySourceSession> localVarReturnType = new TypeReference<IdentitySourceSession>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload the data to be deleted in Okta Uploads external IDs of entities that need to be deleted in Okta from the
     * Identity Source for the given session
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     * @param bulkDeleteRequestBody
     *            (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void uploadIdentitySourceDataForDelete(String identitySourceId, String sessionId,
            BulkDeleteRequestBody bulkDeleteRequestBody) throws ApiException {
        this.uploadIdentitySourceDataForDelete(identitySourceId, sessionId, bulkDeleteRequestBody,
                Collections.emptyMap());
    }

    /**
     * Upload the data to be deleted in Okta Uploads external IDs of entities that need to be deleted in Okta from the
     * Identity Source for the given session
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     * @param bulkDeleteRequestBody
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void uploadIdentitySourceDataForDelete(String identitySourceId, String sessionId,
            BulkDeleteRequestBody bulkDeleteRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = bulkDeleteRequestBody;

        // verify the required parameter 'identitySourceId' is set
        if (identitySourceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceDataForDelete");
        }

        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'sessionId' when calling uploadIdentitySourceDataForDelete");
        }

        // create path and map variables
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-delete"
                .replaceAll("\\{" + "identitySourceId" + "\\}", apiClient.escapeString(identitySourceId.toString()))
                .replaceAll("\\{" + "sessionId" + "\\}", apiClient.escapeString(sessionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Upload the data to be upserted in Okta Uploads entities that need to be inserted or updated in Okta from the
     * Identity Source for the given session
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     * @param bulkUpsertRequestBody
     *            (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void uploadIdentitySourceDataForUpsert(String identitySourceId, String sessionId,
            BulkUpsertRequestBody bulkUpsertRequestBody) throws ApiException {
        this.uploadIdentitySourceDataForUpsert(identitySourceId, sessionId, bulkUpsertRequestBody,
                Collections.emptyMap());
    }

    /**
     * Upload the data to be upserted in Okta Uploads entities that need to be inserted or updated in Okta from the
     * Identity Source for the given session
     *
     * @param identitySourceId
     *            The ID of the Identity Source for which the session is created (required)
     * @param sessionId
     *            The ID of the Identity Source Session (required)
     * @param bulkUpsertRequestBody
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void uploadIdentitySourceDataForUpsert(String identitySourceId, String sessionId,
            BulkUpsertRequestBody bulkUpsertRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = bulkUpsertRequestBody;

        // verify the required parameter 'identitySourceId' is set
        if (identitySourceId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'identitySourceId' when calling uploadIdentitySourceDataForUpsert");
        }

        // verify the required parameter 'sessionId' is set
        if (sessionId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'sessionId' when calling uploadIdentitySourceDataForUpsert");
        }

        // create path and map variables
        String localVarPath = "/api/v1/identity-sources/{identitySourceId}/sessions/{sessionId}/bulk-upsert"
                .replaceAll("\\{" + "identitySourceId" + "\\}", apiClient.escapeString(identitySourceId.toString()))
                .replaceAll("\\{" + "sessionId" + "\\}", apiClient.escapeString(sessionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
