/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.ClientPrivilegesSetting;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ThirdPartyAdminSetting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgSettingAdminApi {

    private ApiClient apiClient;

    public OrgSettingAdminApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrgSettingAdminApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign the Default Public Client App Role Setting Assigns the [Super Admin
     * role](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext_superadmin) as the default role for new
     * public client apps
     *
     * @param clientPrivilegesSetting
     *            (optional)
     *
     * @return ClientPrivilegesSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ClientPrivilegesSetting assignClientPrivilegesSetting(ClientPrivilegesSetting clientPrivilegesSetting)
            throws ApiException {
        return this.assignClientPrivilegesSetting(clientPrivilegesSetting, Collections.emptyMap());
    }

    /**
     * Assign the Default Public Client App Role Setting Assigns the [Super Admin
     * role](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext_superadmin) as the default role for new
     * public client apps
     *
     * @param clientPrivilegesSetting
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ClientPrivilegesSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ClientPrivilegesSetting assignClientPrivilegesSetting(ClientPrivilegesSetting clientPrivilegesSetting,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = clientPrivilegesSetting;

        // create path and map variables
        String localVarPath = "/api/v1/org/settings/clientPrivilegesSetting";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ClientPrivilegesSetting> localVarReturnType = new TypeReference<ClientPrivilegesSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the Default Public Client App Role Setting Retrieves the org setting to assign the [Super Admin
     * role](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext_superadmin) to new public client apps
     *
     * @return ClientPrivilegesSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ClientPrivilegesSetting getClientPrivilegesSetting() throws ApiException {
        return this.getClientPrivilegesSetting(Collections.emptyMap());
    }

    /**
     * Retrieve the Default Public Client App Role Setting Retrieves the org setting to assign the [Super Admin
     * role](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext_superadmin) to new public client apps
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ClientPrivilegesSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ClientPrivilegesSetting getClientPrivilegesSetting(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/settings/clientPrivilegesSetting";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ClientPrivilegesSetting> localVarReturnType = new TypeReference<ClientPrivilegesSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the Org Third-Party Admin Setting Retrieves the Third-Party Admin Setting. See [Configure third-party
     * administrators](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;csh_admin-third) in the Okta
     * product documentation.
     *
     * @return ThirdPartyAdminSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThirdPartyAdminSetting getThirdPartyAdminSetting() throws ApiException {
        return this.getThirdPartyAdminSetting(Collections.emptyMap());
    }

    /**
     * Retrieve the Org Third-Party Admin Setting Retrieves the Third-Party Admin Setting. See [Configure third-party
     * administrators](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;csh_admin-third) in the Okta
     * product documentation.
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ThirdPartyAdminSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThirdPartyAdminSetting getThirdPartyAdminSetting(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/orgSettings/thirdPartyAdminSetting";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ThirdPartyAdminSetting> localVarReturnType = new TypeReference<ThirdPartyAdminSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update the Org Third-Party Admin Setting Updates the Third-Party Admin Setting. This setting allows third-party
     * admins to perform administrative actions in the Admin Console, but they can&#39;t do any of the following: *
     * Receive Okta admin email notifications * Contact Okta support * Sign in to the Okta Help Center See [Configure
     * third-party administrators](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;csh_admin-third) in the
     * Okta product documentation.
     *
     * @param thirdPartyAdminSetting
     *            (required)
     *
     * @return ThirdPartyAdminSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThirdPartyAdminSetting updateThirdPartyAdminSetting(ThirdPartyAdminSetting thirdPartyAdminSetting)
            throws ApiException {
        return this.updateThirdPartyAdminSetting(thirdPartyAdminSetting, Collections.emptyMap());
    }

    /**
     * Update the Org Third-Party Admin Setting Updates the Third-Party Admin Setting. This setting allows third-party
     * admins to perform administrative actions in the Admin Console, but they can&#39;t do any of the following: *
     * Receive Okta admin email notifications * Contact Okta support * Sign in to the Okta Help Center See [Configure
     * third-party administrators](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;csh_admin-third) in the
     * Okta product documentation.
     *
     * @param thirdPartyAdminSetting
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ThirdPartyAdminSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThirdPartyAdminSetting updateThirdPartyAdminSetting(ThirdPartyAdminSetting thirdPartyAdminSetting,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = thirdPartyAdminSetting;

        // verify the required parameter 'thirdPartyAdminSetting' is set
        if (thirdPartyAdminSetting == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'thirdPartyAdminSetting' when calling updateThirdPartyAdminSetting");
        }

        // create path and map variables
        String localVarPath = "/api/v1/org/orgSettings/thirdPartyAdminSetting";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ThirdPartyAdminSetting> localVarReturnType = new TypeReference<ThirdPartyAdminSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
