/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ProviderType;
import com.okta.sdk.resource.model.PushProvider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PushProviderApi {

    private ApiClient apiClient;

    public PushProviderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PushProviderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Push Provider Creates a new push provider. Each Push Provider must have a unique &#x60;name&#x60;.
     *
     * @param pushProvider
     *            (required)
     *
     * @return PushProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PushProvider createPushProvider(PushProvider pushProvider) throws ApiException {
        return this.createPushProvider(pushProvider, Collections.emptyMap());
    }

    /**
     * Create a Push Provider Creates a new push provider. Each Push Provider must have a unique &#x60;name&#x60;.
     *
     * @param pushProvider
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PushProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PushProvider createPushProvider(PushProvider pushProvider, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = pushProvider;

        // verify the required parameter 'pushProvider' is set
        if (pushProvider == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'pushProvider' when calling createPushProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/push-providers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<PushProvider> localVarReturnType = new TypeReference<PushProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Push Provider Deletes a push provider by &#x60;pushProviderId&#x60;. If the push provider is currently
     * being used in the org by a custom authenticator, the delete will not be allowed.
     *
     * @param pushProviderId
     *            Id of the push provider (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deletePushProvider(String pushProviderId) throws ApiException {
        this.deletePushProvider(pushProviderId, Collections.emptyMap());
    }

    /**
     * Delete a Push Provider Deletes a push provider by &#x60;pushProviderId&#x60;. If the push provider is currently
     * being used in the org by a custom authenticator, the delete will not be allowed.
     *
     * @param pushProviderId
     *            Id of the push provider (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deletePushProvider(String pushProviderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'pushProviderId' is set
        if (pushProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'pushProviderId' when calling deletePushProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/push-providers/{pushProviderId}".replaceAll("\\{" + "pushProviderId" + "\\}",
                apiClient.escapeString(pushProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Push Provider Retrieves a push provider by &#x60;pushProviderId&#x60;
     *
     * @param pushProviderId
     *            Id of the push provider (required)
     *
     * @return PushProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PushProvider getPushProvider(String pushProviderId) throws ApiException {
        return this.getPushProvider(pushProviderId, Collections.emptyMap());
    }

    /**
     * Retrieve a Push Provider Retrieves a push provider by &#x60;pushProviderId&#x60;
     *
     * @param pushProviderId
     *            Id of the push provider (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PushProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PushProvider getPushProvider(String pushProviderId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'pushProviderId' is set
        if (pushProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'pushProviderId' when calling getPushProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/push-providers/{pushProviderId}".replaceAll("\\{" + "pushProviderId" + "\\}",
                apiClient.escapeString(pushProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<PushProvider> localVarReturnType = new TypeReference<PushProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Push Providers Lists all push providers
     *
     * @param type
     *            Filters push providers by &#x60;providerType&#x60; (optional)
     *
     * @return List&lt;PushProvider&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<PushProvider> listPushProviders(ProviderType type) throws ApiException {
        return this.listPushProviders(type, Collections.emptyMap());
    }

    /**
     * List all Push Providers Lists all push providers
     *
     * @param type
     *            Filters push providers by &#x60;providerType&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;PushProvider&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<PushProvider> listPushProviders(ProviderType type, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/push-providers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("type", type));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<PushProvider>> localVarReturnType = new TypeReference<List<PushProvider>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Push Provider Replaces a push provider by &#x60;pushProviderId&#x60;
     *
     * @param pushProviderId
     *            Id of the push provider (required)
     * @param pushProvider
     *            (required)
     *
     * @return PushProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PushProvider replacePushProvider(String pushProviderId, PushProvider pushProvider) throws ApiException {
        return this.replacePushProvider(pushProviderId, pushProvider, Collections.emptyMap());
    }

    /**
     * Replace a Push Provider Replaces a push provider by &#x60;pushProviderId&#x60;
     *
     * @param pushProviderId
     *            Id of the push provider (required)
     * @param pushProvider
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PushProvider
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PushProvider replacePushProvider(String pushProviderId, PushProvider pushProvider,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = pushProvider;

        // verify the required parameter 'pushProviderId' is set
        if (pushProviderId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'pushProviderId' when calling replacePushProvider");
        }

        // verify the required parameter 'pushProvider' is set
        if (pushProvider == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'pushProvider' when calling replacePushProvider");
        }

        // create path and map variables
        String localVarPath = "/api/v1/push-providers/{pushProviderId}".replaceAll("\\{" + "pushProviderId" + "\\}",
                apiClient.escapeString(pushProviderId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<PushProvider> localVarReturnType = new TypeReference<PushProvider>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
