/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateUpdateIamRolePermissionRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.Permission;
import com.okta.sdk.resource.model.Permissions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleECustomPermissionApi {

    private ApiClient apiClient;

    public RoleECustomPermissionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleECustomPermissionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Custom Role Permission Creates a permission (specified by &#x60;permissionType&#x60;) for a Custom Role
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param permissionType
     *            An okta permission type (required)
     * @param instance
     *            (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void createRolePermission(String roleIdOrLabel, String permissionType,
            CreateUpdateIamRolePermissionRequest instance) throws ApiException {
        this.createRolePermission(roleIdOrLabel, permissionType, instance, Collections.emptyMap());
    }

    /**
     * Create a Custom Role Permission Creates a permission (specified by &#x60;permissionType&#x60;) for a Custom Role
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param permissionType
     *            An okta permission type (required)
     * @param instance
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void createRolePermission(String roleIdOrLabel, String permissionType,
            CreateUpdateIamRolePermissionRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling createRolePermission");
        }

        // verify the required parameter 'permissionType' is set
        if (permissionType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'permissionType' when calling createRolePermission");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType}"
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()))
                .replaceAll("\\{" + "permissionType" + "\\}", apiClient.escapeString(permissionType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete a Custom Role Permission Deletes a permission (identified by &#x60;permissionType&#x60;) from a Custom
     * Role
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param permissionType
     *            An okta permission type (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRolePermission(String roleIdOrLabel, String permissionType) throws ApiException {
        this.deleteRolePermission(roleIdOrLabel, permissionType, Collections.emptyMap());
    }

    /**
     * Delete a Custom Role Permission Deletes a permission (identified by &#x60;permissionType&#x60;) from a Custom
     * Role
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param permissionType
     *            An okta permission type (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRolePermission(String roleIdOrLabel, String permissionType, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling deleteRolePermission");
        }

        // verify the required parameter 'permissionType' is set
        if (permissionType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'permissionType' when calling deleteRolePermission");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType}"
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()))
                .replaceAll("\\{" + "permissionType" + "\\}", apiClient.escapeString(permissionType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Custom Role Permission Retrieves a permission (identified by &#x60;permissionType&#x60;) for a Custom
     * Role
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param permissionType
     *            An okta permission type (required)
     *
     * @return Permission
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Permission getRolePermission(String roleIdOrLabel, String permissionType) throws ApiException {
        return this.getRolePermission(roleIdOrLabel, permissionType, Collections.emptyMap());
    }

    /**
     * Retrieve a Custom Role Permission Retrieves a permission (identified by &#x60;permissionType&#x60;) for a Custom
     * Role
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param permissionType
     *            An okta permission type (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Permission
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Permission getRolePermission(String roleIdOrLabel, String permissionType,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling getRolePermission");
        }

        // verify the required parameter 'permissionType' is set
        if (permissionType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'permissionType' when calling getRolePermission");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType}"
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()))
                .replaceAll("\\{" + "permissionType" + "\\}", apiClient.escapeString(permissionType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Permission> localVarReturnType = new TypeReference<Permission>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Custom Role Permissions Lists all permissions for a Custom Role by &#x60;roleIdOrLabel&#x60;
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     *
     * @return Permissions
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Permissions listRolePermissions(String roleIdOrLabel) throws ApiException {
        return this.listRolePermissions(roleIdOrLabel, Collections.emptyMap());
    }

    /**
     * List all Custom Role Permissions Lists all permissions for a Custom Role by &#x60;roleIdOrLabel&#x60;
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Permissions
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Permissions listRolePermissions(String roleIdOrLabel, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling listRolePermissions");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions"
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Permissions> localVarReturnType = new TypeReference<Permissions>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Custom Role Permission Replaces a permission (specified by &#x60;permissionType&#x60;) for a Custom
     * Role
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param permissionType
     *            An okta permission type (required)
     * @param instance
     *            (optional)
     *
     * @return Permission
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Permission replaceRolePermission(String roleIdOrLabel, String permissionType,
            CreateUpdateIamRolePermissionRequest instance) throws ApiException {
        return this.replaceRolePermission(roleIdOrLabel, permissionType, instance, Collections.emptyMap());
    }

    /**
     * Replace a Custom Role Permission Replaces a permission (specified by &#x60;permissionType&#x60;) for a Custom
     * Role
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param permissionType
     *            An okta permission type (required)
     * @param instance
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Permission
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Permission replaceRolePermission(String roleIdOrLabel, String permissionType,
            CreateUpdateIamRolePermissionRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleIdOrLabel' when calling replaceRolePermission");
        }

        // verify the required parameter 'permissionType' is set
        if (permissionType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'permissionType' when calling replaceRolePermission");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType}"
                .replaceAll("\\{" + "roleIdOrLabel" + "\\}", apiClient.escapeString(roleIdOrLabel.toString()))
                .replaceAll("\\{" + "permissionType" + "\\}", apiClient.escapeString(permissionType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Permission> localVarReturnType = new TypeReference<Permission>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
