/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.GetSsfStreams200Response;
import com.okta.sdk.resource.model.StreamConfiguration;
import com.okta.sdk.resource.model.StreamConfigurationCreateRequest;
import com.okta.sdk.resource.model.WellKnownSSFMetadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SsfTransmitterApi {

    private ApiClient apiClient;

    public SsfTransmitterApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SsfTransmitterApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an SSF Stream Creates an SSF Stream for an event receiver to start receiving security events in the form
     * of Security Event Tokens (SETs) from Okta. An SSF Stream is associated with the Client ID of the OAuth 2.0 access
     * token used to create the stream. The Client ID is provided by Okta for an [OAuth 2.0 app
     * integration](https://help.okta.com/okta_help.htm?id&#x3D;ext_Apps_App_Integration_Wizard-oidc). One SSF Stream is
     * allowed for each Client ID, hence, one SSF Stream is allowed for each app integration in Okta. A maximum of 10
     * SSF Stream configurations can be created for one org.
     *
     * @param instance
     *            (required)
     *
     * @return StreamConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public StreamConfiguration createSsfStream(StreamConfigurationCreateRequest instance) throws ApiException {
        return this.createSsfStream(instance, Collections.emptyMap());
    }

    /**
     * Create an SSF Stream Creates an SSF Stream for an event receiver to start receiving security events in the form
     * of Security Event Tokens (SETs) from Okta. An SSF Stream is associated with the Client ID of the OAuth 2.0 access
     * token used to create the stream. The Client ID is provided by Okta for an [OAuth 2.0 app
     * integration](https://help.okta.com/okta_help.htm?id&#x3D;ext_Apps_App_Integration_Wizard-oidc). One SSF Stream is
     * allowed for each Client ID, hence, one SSF Stream is allowed for each app integration in Okta. A maximum of 10
     * SSF Stream configurations can be created for one org.
     *
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return StreamConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public StreamConfiguration createSsfStream(StreamConfigurationCreateRequest instance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createSsfStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/ssf/stream";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2" };

        TypeReference<StreamConfiguration> localVarReturnType = new TypeReference<StreamConfiguration>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an SSF Stream Deletes the specified SSF Stream. If the &#x60;stream_id&#x60; is not provided in the query
     * string, the associated stream with the Client ID (through the request OAuth 2.0 access token) is deleted.
     * Otherwise, the SSF Stream with the &#x60;stream_id&#x60; is deleted, if found.
     *
     * @param streamId
     *            The ID of the specified SSF Stream configuration (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteSsfStream(String streamId) throws ApiException {
        this.deleteSsfStream(streamId, Collections.emptyMap());
    }

    /**
     * Delete an SSF Stream Deletes the specified SSF Stream. If the &#x60;stream_id&#x60; is not provided in the query
     * string, the associated stream with the Client ID (through the request OAuth 2.0 access token) is deleted.
     * Otherwise, the SSF Stream with the &#x60;stream_id&#x60; is deleted, if found.
     *
     * @param streamId
     *            The ID of the specified SSF Stream configuration (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteSsfStream(String streamId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/ssf/stream";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("stream_id", streamId));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve the SSF Stream configuration(s) Retrieves either a list of all known SSF Stream configurations or the
     * individual configuration if specified by ID. As Stream configurations are tied to a Client ID, only the Stream
     * associated with the Client ID of the request OAuth 2.0 access token can be viewed.
     *
     * @param streamId
     *            The ID of the specified SSF Stream configuration (optional)
     *
     * @return GetSsfStreams200Response
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GetSsfStreams200Response getSsfStreams(String streamId) throws ApiException {
        return this.getSsfStreams(streamId, Collections.emptyMap());
    }

    /**
     * Retrieve the SSF Stream configuration(s) Retrieves either a list of all known SSF Stream configurations or the
     * individual configuration if specified by ID. As Stream configurations are tied to a Client ID, only the Stream
     * associated with the Client ID of the request OAuth 2.0 access token can be viewed.
     *
     * @param streamId
     *            The ID of the specified SSF Stream configuration (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return GetSsfStreams200Response
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public GetSsfStreams200Response getSsfStreams(String streamId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/ssf/stream";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("stream_id", streamId));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2" };

        TypeReference<GetSsfStreams200Response> localVarReturnType = new TypeReference<GetSsfStreams200Response>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve the SSF Transmitter metadata Retrieves SSF Transmitter configuration metadata. This includes all
     * supported endpoints and key information about certain properties of the Okta org as the transmitter, such as
     * &#x60;delivery_methods_supported&#x60;, &#x60;issuer&#x60;, and &#x60;jwks_uri&#x60;.
     *
     * @return WellKnownSSFMetadata
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public WellKnownSSFMetadata getWellknownSsfMetadata() throws ApiException {
        return this.getWellknownSsfMetadata(Collections.emptyMap());
    }

    /**
     * Retrieve the SSF Transmitter metadata Retrieves SSF Transmitter configuration metadata. This includes all
     * supported endpoints and key information about certain properties of the Okta org as the transmitter, such as
     * &#x60;delivery_methods_supported&#x60;, &#x60;issuer&#x60;, and &#x60;jwks_uri&#x60;.
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return WellKnownSSFMetadata
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public WellKnownSSFMetadata getWellknownSsfMetadata(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/.well-known/ssf-configuration";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {};

        TypeReference<WellKnownSSFMetadata> localVarReturnType = new TypeReference<WellKnownSSFMetadata>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an SSF Stream Replaces all properties for an existing SSF Stream configuration. If the
     * &#x60;stream_id&#x60; isn&#39;t provided in the request body, the associated stream with the Client ID (through
     * the request OAuth 2.0 access token) is replaced.
     *
     * @param instance
     *            (required)
     *
     * @return StreamConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public StreamConfiguration replaceSsfStream(StreamConfiguration instance) throws ApiException {
        return this.replaceSsfStream(instance, Collections.emptyMap());
    }

    /**
     * Replace an SSF Stream Replaces all properties for an existing SSF Stream configuration. If the
     * &#x60;stream_id&#x60; isn&#39;t provided in the request body, the associated stream with the Client ID (through
     * the request OAuth 2.0 access token) is replaced.
     *
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return StreamConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public StreamConfiguration replaceSsfStream(StreamConfiguration instance, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceSsfStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/ssf/stream";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2" };

        TypeReference<StreamConfiguration> localVarReturnType = new TypeReference<StreamConfiguration>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update an SSF Stream Updates properties for an existing SSF Stream configuration. If the &#x60;stream_id&#x60;
     * isn&#39;t provided in the request body, the associated stream with the Client ID (through the request OAuth 2.0
     * access token) is updated.
     *
     * @param instance
     *            (required)
     *
     * @return StreamConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public StreamConfiguration updateSsfStream(StreamConfiguration instance) throws ApiException {
        return this.updateSsfStream(instance, Collections.emptyMap());
    }

    /**
     * Update an SSF Stream Updates properties for an existing SSF Stream configuration. If the &#x60;stream_id&#x60;
     * isn&#39;t provided in the request body, the associated stream with the Client ID (through the request OAuth 2.0
     * access token) is updated.
     *
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return StreamConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public StreamConfiguration updateSsfStream(StreamConfiguration instance, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling updateSsfStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/ssf/stream";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts, localVarPath);

        final String[] localVarContentTypes = { "text/xml", "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2" };

        TypeReference<StreamConfiguration> localVarReturnType = new TypeReference<StreamConfiguration>() {
        };
        return apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
