package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObjectActivateLink;
import com.okta.sdk.resource.model.HrefObjectDeactivateLink;
import com.okta.sdk.resource.model.HrefObjectDeleteLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status
 * of an application using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for
 * dynamic discovery of related resources and lifecycle operations.
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status of an application using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for dynamic discovery of related resources and lifecycle operations.")
@JsonPropertyOrder({ APIServiceIntegrationSecretLinks.JSON_PROPERTY_ACTIVATE,
        APIServiceIntegrationSecretLinks.JSON_PROPERTY_DEACTIVATE,
        APIServiceIntegrationSecretLinks.JSON_PROPERTY_DELETE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class APIServiceIntegrationSecretLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIVATE = "activate";
    private HrefObjectActivateLink activate;

    public static final String JSON_PROPERTY_DEACTIVATE = "deactivate";
    private HrefObjectDeactivateLink deactivate;

    public static final String JSON_PROPERTY_DELETE = "delete";
    private HrefObjectDeleteLink delete;

    public APIServiceIntegrationSecretLinks() {
    }

    public APIServiceIntegrationSecretLinks activate(HrefObjectActivateLink activate) {

        this.activate = activate;
        return this;
    }

    /**
     * Get activate
     *
     * @return activate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectActivateLink getActivate() {
        return activate;
    }

    @JsonProperty(JSON_PROPERTY_ACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setActivate(HrefObjectActivateLink activate) {
        this.activate = activate;
    }

    public APIServiceIntegrationSecretLinks deactivate(HrefObjectDeactivateLink deactivate) {

        this.deactivate = deactivate;
        return this;
    }

    /**
     * Get deactivate
     *
     * @return deactivate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DEACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectDeactivateLink getDeactivate() {
        return deactivate;
    }

    @JsonProperty(JSON_PROPERTY_DEACTIVATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeactivate(HrefObjectDeactivateLink deactivate) {
        this.deactivate = deactivate;
    }

    public APIServiceIntegrationSecretLinks delete(HrefObjectDeleteLink delete) {

        this.delete = delete;
        return this;
    }

    /**
     * Get delete
     *
     * @return delete
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DELETE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectDeleteLink getDelete() {
        return delete;
    }

    @JsonProperty(JSON_PROPERTY_DELETE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDelete(HrefObjectDeleteLink delete) {
        this.delete = delete;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        APIServiceIntegrationSecretLinks apIServiceIntegrationSecretLinks = (APIServiceIntegrationSecretLinks) o;
        return Objects.equals(this.activate, apIServiceIntegrationSecretLinks.activate)
                && Objects.equals(this.deactivate, apIServiceIntegrationSecretLinks.deactivate)
                && Objects.equals(this.delete, apIServiceIntegrationSecretLinks.delete);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(activate, deactivate, delete);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIServiceIntegrationSecretLinks {\n");
        sb.append("    activate: ").append(toIndentedString(activate)).append("\n");
        sb.append("    deactivate: ").append(toIndentedString(deactivate)).append("\n");
        sb.append("    delete: ").append(toIndentedString(delete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
