package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObjectAppLink;
import com.okta.sdk.resource.model.HrefObjectLogoLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AppLink
 */
@JsonPropertyOrder({ AppLink.JSON_PROPERTY_LOGIN, AppLink.JSON_PROPERTY_LOGO, AppLink.JSON_PROPERTY_APP_ASSIGNMENT_ID,
        AppLink.JSON_PROPERTY_APP_INSTANCE_ID, AppLink.JSON_PROPERTY_APP_NAME, AppLink.JSON_PROPERTY_CREDENTIALS_SETUP,
        AppLink.JSON_PROPERTY_HIDDEN, AppLink.JSON_PROPERTY_ID, AppLink.JSON_PROPERTY_LABEL,
        AppLink.JSON_PROPERTY_LINK_URL, AppLink.JSON_PROPERTY_LOGO_URL, AppLink.JSON_PROPERTY_SORT_ORDER })
@JsonTypeName("appLink")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AppLink implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_LOGIN = "login";
    private HrefObjectAppLink login;

    public static final String JSON_PROPERTY_LOGO = "logo";
    private HrefObjectLogoLink logo;

    public static final String JSON_PROPERTY_APP_ASSIGNMENT_ID = "appAssignmentId";
    private String appAssignmentId;

    public static final String JSON_PROPERTY_APP_INSTANCE_ID = "appInstanceId";
    private String appInstanceId;

    public static final String JSON_PROPERTY_APP_NAME = "appName";
    private String appName;

    public static final String JSON_PROPERTY_CREDENTIALS_SETUP = "credentialsSetup";
    private Boolean credentialsSetup;

    public static final String JSON_PROPERTY_HIDDEN = "hidden";
    private Boolean hidden;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_LINK_URL = "linkUrl";
    private String linkUrl;

    public static final String JSON_PROPERTY_LOGO_URL = "logoUrl";
    private String logoUrl;

    public static final String JSON_PROPERTY_SORT_ORDER = "sortOrder";
    private Integer sortOrder;

    public AppLink() {
    }

    /*
     * @JsonCreator public AppLink(
     *
     * @JsonProperty(JSON_PROPERTY_APP_ASSIGNMENT_ID) String appAssignmentId,
     *
     * @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID) String appInstanceId,
     *
     * @JsonProperty(JSON_PROPERTY_APP_NAME) String appName,
     *
     * @JsonProperty(JSON_PROPERTY_CREDENTIALS_SETUP) Boolean credentialsSetup,
     *
     * @JsonProperty(JSON_PROPERTY_HIDDEN) Boolean hidden,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LABEL) String label,
     *
     * @JsonProperty(JSON_PROPERTY_LINK_URL) String linkUrl,
     *
     * @JsonProperty(JSON_PROPERTY_LOGO_URL) String logoUrl,
     *
     * @JsonProperty(JSON_PROPERTY_SORT_ORDER) Integer sortOrder ) { this(); this.appAssignmentId = appAssignmentId;
     * this.appInstanceId = appInstanceId; this.appName = appName; this.credentialsSetup = credentialsSetup; this.hidden
     * = hidden; this.id = id; this.label = label; this.linkUrl = linkUrl; this.logoUrl = logoUrl; this.sortOrder =
     * sortOrder; }
     */

    public AppLink login(HrefObjectAppLink login) {

        this.login = login;
        return this;
    }

    /**
     * Get login
     *
     * @return login
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectAppLink getLogin() {
        return login;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogin(HrefObjectAppLink login) {
        this.login = login;
    }

    public AppLink logo(HrefObjectLogoLink logo) {

        this.logo = logo;
        return this;
    }

    /**
     * Get logo
     *
     * @return logo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectLogoLink getLogo() {
        return logo;
    }

    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(HrefObjectLogoLink logo) {
        this.logo = logo;
    }

    /**
     * Get appAssignmentId
     *
     * @return appAssignmentId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APP_ASSIGNMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppAssignmentId() {
        return appAssignmentId;
    }

    /**
     * Get appInstanceId
     *
     * @return appInstanceId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppInstanceId() {
        return appInstanceId;
    }

    /**
     * Get appName
     *
     * @return appName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APP_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppName() {
        return appName;
    }

    /**
     * Get credentialsSetup
     *
     * @return credentialsSetup
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS_SETUP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getCredentialsSetup() {
        return credentialsSetup;
    }

    /**
     * Get hidden
     *
     * @return hidden
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HIDDEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getHidden() {
        return hidden;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Get label
     *
     * @return label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }

    /**
     * Get linkUrl
     *
     * @return linkUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINK_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLinkUrl() {
        return linkUrl;
    }

    /**
     * Get logoUrl
     *
     * @return logoUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOGO_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogoUrl() {
        return logoUrl;
    }

    /**
     * Get sortOrder
     *
     * @return sortOrder
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SORT_ORDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getSortOrder() {
        return sortOrder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppLink appLink = (AppLink) o;
        return Objects.equals(this.login, appLink.login) && Objects.equals(this.logo, appLink.logo)
                && Objects.equals(this.appAssignmentId, appLink.appAssignmentId)
                && Objects.equals(this.appInstanceId, appLink.appInstanceId)
                && Objects.equals(this.appName, appLink.appName)
                && Objects.equals(this.credentialsSetup, appLink.credentialsSetup)
                && Objects.equals(this.hidden, appLink.hidden) && Objects.equals(this.id, appLink.id)
                && Objects.equals(this.label, appLink.label) && Objects.equals(this.linkUrl, appLink.linkUrl)
                && Objects.equals(this.logoUrl, appLink.logoUrl) && Objects.equals(this.sortOrder, appLink.sortOrder);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(login, logo, appAssignmentId, appInstanceId, appName, credentialsSetup, hidden, id, label,
                linkUrl, logoUrl, sortOrder);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppLink {\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
        sb.append("    appAssignmentId: ").append(toIndentedString(appAssignmentId)).append("\n");
        sb.append("    appInstanceId: ").append(toIndentedString(appInstanceId)).append("\n");
        sb.append("    appName: ").append(toIndentedString(appName)).append("\n");
        sb.append("    credentialsSetup: ").append(toIndentedString(credentialsSetup)).append("\n");
        sb.append("    hidden: ").append(toIndentedString(hidden)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    linkUrl: ").append(toIndentedString(linkUrl)).append("\n");
        sb.append("    logoUrl: ").append(toIndentedString(logoUrl)).append("\n");
        sb.append("    sortOrder: ").append(toIndentedString(sortOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
