package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorMethodType;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.LinksSelfAndLifecycle;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorMethodBase
 */
@JsonPropertyOrder({ AuthenticatorMethodBase.JSON_PROPERTY_STATUS, AuthenticatorMethodBase.JSON_PROPERTY_TYPE,
        AuthenticatorMethodBase.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = AuthenticatorMethodBase.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = AuthenticatorMethodWithVerifiableProperties.class, name = "cert"),
        @JsonSubTypes.Type(value = AuthenticatorMethodWithVerifiableProperties.class, name = "duo"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "email"),
        @JsonSubTypes.Type(value = AuthenticatorMethodWithVerifiableProperties.class, name = "idp"),
        @JsonSubTypes.Type(value = AuthenticatorMethodOtp.class, name = "otp"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "password"),
        @JsonSubTypes.Type(value = AuthenticatorMethodPush.class, name = "push"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "security_question"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSignedNonce.class, name = "signed_nonce"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "sms"),
        @JsonSubTypes.Type(value = AuthenticatorMethodTotp.class, name = "totp"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "voice"),
        @JsonSubTypes.Type(value = AuthenticatorMethodWebAuthn.class, name = "webauthn"), })

public class AuthenticatorMethodBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    public static final String JSON_PROPERTY_TYPE = "type";
    protected AuthenticatorMethodType type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelfAndLifecycle links;

    public AuthenticatorMethodBase() {
    }

    public AuthenticatorMethodBase status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public AuthenticatorMethodBase type(AuthenticatorMethodType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorMethodType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(AuthenticatorMethodType type) {
        this.type = type;
    }

    public AuthenticatorMethodBase links(LinksSelfAndLifecycle links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelfAndLifecycle getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelfAndLifecycle links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorMethodBase authenticatorMethodBase = (AuthenticatorMethodBase) o;
        return Objects.equals(this.status, authenticatorMethodBase.status)
                && Objects.equals(this.type, authenticatorMethodBase.type)
                && Objects.equals(this.links, authenticatorMethodBase.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorMethodBase {\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
