package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LocationGranularity;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * BehaviorRuleSettingsAnomalousLocation
 */
@JsonPropertyOrder({ BehaviorRuleSettingsAnomalousLocation.JSON_PROPERTY_MAX_EVENTS_USED_FOR_EVALUATION,
        BehaviorRuleSettingsAnomalousLocation.JSON_PROPERTY_MIN_EVENTS_NEEDED_FOR_EVALUATION,
        BehaviorRuleSettingsAnomalousLocation.JSON_PROPERTY_GRANULARITY,
        BehaviorRuleSettingsAnomalousLocation.JSON_PROPERTY_RADIUS_KILOMETERS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class BehaviorRuleSettingsAnomalousLocation implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_MAX_EVENTS_USED_FOR_EVALUATION = "maxEventsUsedForEvaluation";
    private Integer maxEventsUsedForEvaluation = 20;

    public static final String JSON_PROPERTY_MIN_EVENTS_NEEDED_FOR_EVALUATION = "minEventsNeededForEvaluation";
    private Integer minEventsNeededForEvaluation = 0;

    public static final String JSON_PROPERTY_GRANULARITY = "granularity";
    private LocationGranularity granularity;

    public static final String JSON_PROPERTY_RADIUS_KILOMETERS = "radiusKilometers";
    private Integer radiusKilometers;

    public BehaviorRuleSettingsAnomalousLocation() {
    }

    public BehaviorRuleSettingsAnomalousLocation maxEventsUsedForEvaluation(Integer maxEventsUsedForEvaluation) {

        this.maxEventsUsedForEvaluation = maxEventsUsedForEvaluation;
        return this;
    }

    /**
     * Get maxEventsUsedForEvaluation minimum: 1 maximum: 100
     *
     * @return maxEventsUsedForEvaluation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_MAX_EVENTS_USED_FOR_EVALUATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMaxEventsUsedForEvaluation() {
        return maxEventsUsedForEvaluation;
    }

    @JsonProperty(JSON_PROPERTY_MAX_EVENTS_USED_FOR_EVALUATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMaxEventsUsedForEvaluation(Integer maxEventsUsedForEvaluation) {
        this.maxEventsUsedForEvaluation = maxEventsUsedForEvaluation;
    }

    public BehaviorRuleSettingsAnomalousLocation minEventsNeededForEvaluation(Integer minEventsNeededForEvaluation) {

        this.minEventsNeededForEvaluation = minEventsNeededForEvaluation;
        return this;
    }

    /**
     * Get minEventsNeededForEvaluation minimum: 0 maximum: 10
     *
     * @return minEventsNeededForEvaluation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_MIN_EVENTS_NEEDED_FOR_EVALUATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMinEventsNeededForEvaluation() {
        return minEventsNeededForEvaluation;
    }

    @JsonProperty(JSON_PROPERTY_MIN_EVENTS_NEEDED_FOR_EVALUATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinEventsNeededForEvaluation(Integer minEventsNeededForEvaluation) {
        this.minEventsNeededForEvaluation = minEventsNeededForEvaluation;
    }

    public BehaviorRuleSettingsAnomalousLocation granularity(LocationGranularity granularity) {

        this.granularity = granularity;
        return this;
    }

    /**
     * Get granularity
     *
     * @return granularity
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_GRANULARITY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public LocationGranularity getGranularity() {
        return granularity;
    }

    @JsonProperty(JSON_PROPERTY_GRANULARITY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setGranularity(LocationGranularity granularity) {
        this.granularity = granularity;
    }

    public BehaviorRuleSettingsAnomalousLocation radiusKilometers(Integer radiusKilometers) {

        this.radiusKilometers = radiusKilometers;
        return this;
    }

    /**
     * Required when &#x60;granularity&#x60; is &#x60;LAT_LONG&#x60;. Radius from the provided coordinates in
     * kilometers.
     *
     * @return radiusKilometers
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Required when `granularity` is `LAT_LONG`. Radius from the provided coordinates in kilometers.")
    @JsonProperty(JSON_PROPERTY_RADIUS_KILOMETERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getRadiusKilometers() {
        return radiusKilometers;
    }

    @JsonProperty(JSON_PROPERTY_RADIUS_KILOMETERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRadiusKilometers(Integer radiusKilometers) {
        this.radiusKilometers = radiusKilometers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BehaviorRuleSettingsAnomalousLocation behaviorRuleSettingsAnomalousLocation = (BehaviorRuleSettingsAnomalousLocation) o;
        return Objects.equals(this.maxEventsUsedForEvaluation,
                behaviorRuleSettingsAnomalousLocation.maxEventsUsedForEvaluation)
                && Objects.equals(this.minEventsNeededForEvaluation,
                        behaviorRuleSettingsAnomalousLocation.minEventsNeededForEvaluation)
                && Objects.equals(this.granularity, behaviorRuleSettingsAnomalousLocation.granularity)
                && Objects.equals(this.radiusKilometers, behaviorRuleSettingsAnomalousLocation.radiusKilometers);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(maxEventsUsedForEvaluation, minEventsNeededForEvaluation, granularity, radiusKilometers);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BehaviorRuleSettingsAnomalousLocation {\n");
        sb.append("    maxEventsUsedForEvaluation: ").append(toIndentedString(maxEventsUsedForEvaluation)).append("\n");
        sb.append("    minEventsNeededForEvaluation: ").append(toIndentedString(minEventsNeededForEvaluation))
                .append("\n");
        sb.append("    granularity: ").append(toIndentedString(granularity)).append("\n");
        sb.append("    radiusKilometers: ").append(toIndentedString(radiusKilometers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
