package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Rules for matching and creating users
 */
@ApiModel(description = "Rules for matching and creating users")
@JsonPropertyOrder({ CapabilitiesImportRulesUserCreateAndMatchObject.JSON_PROPERTY_ALLOW_PARTIAL_MATCH,
        CapabilitiesImportRulesUserCreateAndMatchObject.JSON_PROPERTY_AUTO_ACTIVATE_NEW_USERS,
        CapabilitiesImportRulesUserCreateAndMatchObject.JSON_PROPERTY_AUTO_CONFIRM_EXACT_MATCH,
        CapabilitiesImportRulesUserCreateAndMatchObject.JSON_PROPERTY_AUTO_CONFIRM_NEW_USERS,
        CapabilitiesImportRulesUserCreateAndMatchObject.JSON_PROPERTY_AUTO_CONFIRM_PARTIAL_MATCH,
        CapabilitiesImportRulesUserCreateAndMatchObject.JSON_PROPERTY_EXACT_MATCH_CRITERIA })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CapabilitiesImportRulesUserCreateAndMatchObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALLOW_PARTIAL_MATCH = "allowPartialMatch";
    private Boolean allowPartialMatch;

    public static final String JSON_PROPERTY_AUTO_ACTIVATE_NEW_USERS = "autoActivateNewUsers";
    private Boolean autoActivateNewUsers;

    public static final String JSON_PROPERTY_AUTO_CONFIRM_EXACT_MATCH = "autoConfirmExactMatch";
    private Boolean autoConfirmExactMatch;

    public static final String JSON_PROPERTY_AUTO_CONFIRM_NEW_USERS = "autoConfirmNewUsers";
    private Boolean autoConfirmNewUsers;

    public static final String JSON_PROPERTY_AUTO_CONFIRM_PARTIAL_MATCH = "autoConfirmPartialMatch";
    private Boolean autoConfirmPartialMatch;

    /**
     * Determines the attribute to match users
     */
    public enum ExactMatchCriteriaEnum {
        EMAIL(String.valueOf("EMAIL")),

        USERNAME(String.valueOf("USERNAME")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        ExactMatchCriteriaEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ExactMatchCriteriaEnum fromValue(String value) {
            for (ExactMatchCriteriaEnum b : ExactMatchCriteriaEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_EXACT_MATCH_CRITERIA = "exactMatchCriteria";
    private ExactMatchCriteriaEnum exactMatchCriteria;

    public CapabilitiesImportRulesUserCreateAndMatchObject() {
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject allowPartialMatch(Boolean allowPartialMatch) {

        this.allowPartialMatch = allowPartialMatch;
        return this;
    }

    /**
     * Allows user import upon partial matching. Partial matching occurs when the first and last names of an imported
     * user match those of an existing Okta user, even if the username or email attributes don&#39;t match.
     *
     * @return allowPartialMatch
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Allows user import upon partial matching. Partial matching occurs when the first and last names of an imported user match those of an existing Okta user, even if the username or email attributes don't match.")
    @JsonProperty(JSON_PROPERTY_ALLOW_PARTIAL_MATCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAllowPartialMatch() {
        return allowPartialMatch;
    }

    @JsonProperty(JSON_PROPERTY_ALLOW_PARTIAL_MATCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAllowPartialMatch(Boolean allowPartialMatch) {
        this.allowPartialMatch = allowPartialMatch;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject autoActivateNewUsers(Boolean autoActivateNewUsers) {

        this.autoActivateNewUsers = autoActivateNewUsers;
        return this;
    }

    /**
     * If set to &#x60;true&#x60;, imported new users are automatically activated.
     *
     * @return autoActivateNewUsers
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If set to `true`, imported new users are automatically activated.")
    @JsonProperty(JSON_PROPERTY_AUTO_ACTIVATE_NEW_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAutoActivateNewUsers() {
        return autoActivateNewUsers;
    }

    @JsonProperty(JSON_PROPERTY_AUTO_ACTIVATE_NEW_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAutoActivateNewUsers(Boolean autoActivateNewUsers) {
        this.autoActivateNewUsers = autoActivateNewUsers;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject autoConfirmExactMatch(Boolean autoConfirmExactMatch) {

        this.autoConfirmExactMatch = autoConfirmExactMatch;
        return this;
    }

    /**
     * If set to &#x60;true&#x60;, exact-matched users are automatically confirmed on activation. If set to
     * &#x60;false&#x60;, exact-matched users need to be confirmed manually.
     *
     * @return autoConfirmExactMatch
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If set to `true`, exact-matched users are automatically confirmed on activation. If set to `false`, exact-matched users need to be confirmed manually.")
    @JsonProperty(JSON_PROPERTY_AUTO_CONFIRM_EXACT_MATCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAutoConfirmExactMatch() {
        return autoConfirmExactMatch;
    }

    @JsonProperty(JSON_PROPERTY_AUTO_CONFIRM_EXACT_MATCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAutoConfirmExactMatch(Boolean autoConfirmExactMatch) {
        this.autoConfirmExactMatch = autoConfirmExactMatch;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject autoConfirmNewUsers(Boolean autoConfirmNewUsers) {

        this.autoConfirmNewUsers = autoConfirmNewUsers;
        return this;
    }

    /**
     * If set to &#x60;true&#x60;, imported new users are automatically confirmed on activation. This doesn&#39;t apply
     * to imported users that already exist in Okta.
     *
     * @return autoConfirmNewUsers
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If set to `true`, imported new users are automatically confirmed on activation. This doesn't apply to imported users that already exist in Okta.")
    @JsonProperty(JSON_PROPERTY_AUTO_CONFIRM_NEW_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAutoConfirmNewUsers() {
        return autoConfirmNewUsers;
    }

    @JsonProperty(JSON_PROPERTY_AUTO_CONFIRM_NEW_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAutoConfirmNewUsers(Boolean autoConfirmNewUsers) {
        this.autoConfirmNewUsers = autoConfirmNewUsers;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject autoConfirmPartialMatch(Boolean autoConfirmPartialMatch) {

        this.autoConfirmPartialMatch = autoConfirmPartialMatch;
        return this;
    }

    /**
     * If set to &#x60;true&#x60;, partially matched users are automatically confirmed on activation. If set to
     * &#x60;false&#x60;, partially matched users need to be confirmed manually.
     *
     * @return autoConfirmPartialMatch
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If set to `true`, partially matched users are automatically confirmed on activation. If set to `false`, partially matched users need to be confirmed manually.")
    @JsonProperty(JSON_PROPERTY_AUTO_CONFIRM_PARTIAL_MATCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAutoConfirmPartialMatch() {
        return autoConfirmPartialMatch;
    }

    @JsonProperty(JSON_PROPERTY_AUTO_CONFIRM_PARTIAL_MATCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAutoConfirmPartialMatch(Boolean autoConfirmPartialMatch) {
        this.autoConfirmPartialMatch = autoConfirmPartialMatch;
    }

    public CapabilitiesImportRulesUserCreateAndMatchObject exactMatchCriteria(
            ExactMatchCriteriaEnum exactMatchCriteria) {

        this.exactMatchCriteria = exactMatchCriteria;
        return this;
    }

    /**
     * Determines the attribute to match users
     *
     * @return exactMatchCriteria
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines the attribute to match users")
    @JsonProperty(JSON_PROPERTY_EXACT_MATCH_CRITERIA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ExactMatchCriteriaEnum getExactMatchCriteria() {
        return exactMatchCriteria;
    }

    @JsonProperty(JSON_PROPERTY_EXACT_MATCH_CRITERIA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExactMatchCriteria(ExactMatchCriteriaEnum exactMatchCriteria) {
        this.exactMatchCriteria = exactMatchCriteria;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CapabilitiesImportRulesUserCreateAndMatchObject capabilitiesImportRulesUserCreateAndMatchObject = (CapabilitiesImportRulesUserCreateAndMatchObject) o;
        return Objects.equals(this.allowPartialMatch, capabilitiesImportRulesUserCreateAndMatchObject.allowPartialMatch)
                && Objects.equals(this.autoActivateNewUsers,
                        capabilitiesImportRulesUserCreateAndMatchObject.autoActivateNewUsers)
                && Objects.equals(this.autoConfirmExactMatch,
                        capabilitiesImportRulesUserCreateAndMatchObject.autoConfirmExactMatch)
                && Objects.equals(this.autoConfirmNewUsers,
                        capabilitiesImportRulesUserCreateAndMatchObject.autoConfirmNewUsers)
                && Objects.equals(this.autoConfirmPartialMatch,
                        capabilitiesImportRulesUserCreateAndMatchObject.autoConfirmPartialMatch)
                && Objects.equals(this.exactMatchCriteria,
                        capabilitiesImportRulesUserCreateAndMatchObject.exactMatchCriteria);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(allowPartialMatch, autoActivateNewUsers, autoConfirmExactMatch, autoConfirmNewUsers,
                autoConfirmPartialMatch, exactMatchCriteria);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapabilitiesImportRulesUserCreateAndMatchObject {\n");
        sb.append("    allowPartialMatch: ").append(toIndentedString(allowPartialMatch)).append("\n");
        sb.append("    autoActivateNewUsers: ").append(toIndentedString(autoActivateNewUsers)).append("\n");
        sb.append("    autoConfirmExactMatch: ").append(toIndentedString(autoConfirmExactMatch)).append("\n");
        sb.append("    autoConfirmNewUsers: ").append(toIndentedString(autoConfirmNewUsers)).append("\n");
        sb.append("    autoConfirmPartialMatch: ").append(toIndentedString(autoConfirmPartialMatch)).append("\n");
        sb.append("    exactMatchCriteria: ").append(toIndentedString(exactMatchCriteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
