package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CapabilitiesImportRulesObject;
import com.okta.sdk.resource.model.CapabilitiesImportSettingsObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines the configuration for the INBOUND_PROVISIONING feature
 */
@ApiModel(description = "Defines the configuration for the INBOUND_PROVISIONING feature")
@JsonPropertyOrder({ CapabilitiesInboundProvisioningObject.JSON_PROPERTY_IMPORT_RULES,
        CapabilitiesInboundProvisioningObject.JSON_PROPERTY_IMPORT_SETTINGS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CapabilitiesInboundProvisioningObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_IMPORT_RULES = "importRules";
    private CapabilitiesImportRulesObject importRules;

    public static final String JSON_PROPERTY_IMPORT_SETTINGS = "importSettings";
    private CapabilitiesImportSettingsObject importSettings;

    public CapabilitiesInboundProvisioningObject() {
    }

    public CapabilitiesInboundProvisioningObject importRules(CapabilitiesImportRulesObject importRules) {

        this.importRules = importRules;
        return this;
    }

    /**
     * Get importRules
     *
     * @return importRules
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_IMPORT_RULES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public CapabilitiesImportRulesObject getImportRules() {
        return importRules;
    }

    @JsonProperty(JSON_PROPERTY_IMPORT_RULES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setImportRules(CapabilitiesImportRulesObject importRules) {
        this.importRules = importRules;
    }

    public CapabilitiesInboundProvisioningObject importSettings(CapabilitiesImportSettingsObject importSettings) {

        this.importSettings = importSettings;
        return this;
    }

    /**
     * Get importSettings
     *
     * @return importSettings
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_IMPORT_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public CapabilitiesImportSettingsObject getImportSettings() {
        return importSettings;
    }

    @JsonProperty(JSON_PROPERTY_IMPORT_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setImportSettings(CapabilitiesImportSettingsObject importSettings) {
        this.importSettings = importSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CapabilitiesInboundProvisioningObject capabilitiesInboundProvisioningObject = (CapabilitiesInboundProvisioningObject) o;
        return Objects.equals(this.importRules, capabilitiesInboundProvisioningObject.importRules)
                && Objects.equals(this.importSettings, capabilitiesInboundProvisioningObject.importSettings);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(importRules, importSettings);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapabilitiesInboundProvisioningObject {\n");
        sb.append("    importRules: ").append(toIndentedString(importRules)).append("\n");
        sb.append("    importSettings: ").append(toIndentedString(importSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
