package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CreateResourceSetRequest
 */
@JsonPropertyOrder({ CreateResourceSetRequest.JSON_PROPERTY_DESCRIPTION, CreateResourceSetRequest.JSON_PROPERTY_LABEL,
        CreateResourceSetRequest.JSON_PROPERTY_RESOURCES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CreateResourceSetRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private List<String> resources = new ArrayList<>();

    public CreateResourceSetRequest() {
    }

    public CreateResourceSetRequest description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Resource Set
     *
     * @return description
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Description of the Resource Set")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateResourceSetRequest label(String label) {

        this.label = label;
        return this;
    }

    /**
     * Unique name for the Resource Set
     *
     * @return label
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Unique name for the Resource Set")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public CreateResourceSetRequest resources(List<String> resources) {

        this.resources = resources;
        return this;
    }

    public CreateResourceSetRequest addresourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    /**
     * The endpoint (URL) that references all resource objects included in the Resource Set. Resources are identified by
     * either an Okta Resource Name (ORN) or by a REST URL format. See [Okta Resource
     * Name](/openapi/okta-management/guides/roles/#okta-resource-name-orn).
     *
     * @return resources
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The endpoint (URL) that references all resource objects included in the Resource Set. Resources are identified by either an Okta Resource Name (ORN) or by a REST URL format. See [Okta Resource Name](/openapi/okta-management/guides/roles/#okta-resource-name-orn).")
    @JsonProperty(JSON_PROPERTY_RESOURCES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<String> getResources() {
        return resources;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateResourceSetRequest createResourceSetRequest = (CreateResourceSetRequest) o;
        return Objects.equals(this.description, createResourceSetRequest.description)
                && Objects.equals(this.label, createResourceSetRequest.label)
                && Objects.equals(this.resources, createResourceSetRequest.resources);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, label, resources);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateResourceSetRequest {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    resources: ").append(toIndentedString(resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
