package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The ID of the User type. Add this value if you want to create a User with a non-default [User
 * Type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/). The User Type determines
 * which [schema](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Schema/) applies to that
 * user. After a User has been created, the User can only be assigned a different User Type by an administrator through
 * a full replacement (&#x60;PUT&#x60;) operation.
 */
@ApiModel(description = "The ID of the User type. Add this value if you want to create a User with a non-default [User Type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/). The User Type determines which [schema](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Schema/) applies to that user. After a User has been created, the User can only be assigned a different User Type by an administrator through a full replacement (`PUT`) operation.")
@JsonPropertyOrder({ CreateUserRequestType.JSON_PROPERTY_ID })
@JsonTypeName("CreateUserRequest_type")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CreateUserRequestType implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public CreateUserRequestType() {
    }

    public CreateUserRequestType id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The ID of the User Type
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the User Type")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateUserRequestType createUserRequestType = (CreateUserRequestType) o;
        return Objects.equals(this.id, createUserRequestType.id);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUserRequestType {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
