package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CsrMetadataSubject
 */
@JsonPropertyOrder({ CsrMetadataSubject.JSON_PROPERTY_COMMON_NAME, CsrMetadataSubject.JSON_PROPERTY_COUNTRY_NAME,
        CsrMetadataSubject.JSON_PROPERTY_LOCALITY_NAME, CsrMetadataSubject.JSON_PROPERTY_ORGANIZATIONAL_UNIT_NAME,
        CsrMetadataSubject.JSON_PROPERTY_ORGANIZATION_NAME, CsrMetadataSubject.JSON_PROPERTY_STATE_OR_PROVINCE_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CsrMetadataSubject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_COMMON_NAME = "commonName";
    private String commonName;

    public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
    private String countryName;

    public static final String JSON_PROPERTY_LOCALITY_NAME = "localityName";
    private String localityName;

    public static final String JSON_PROPERTY_ORGANIZATIONAL_UNIT_NAME = "organizationalUnitName";
    private String organizationalUnitName;

    public static final String JSON_PROPERTY_ORGANIZATION_NAME = "organizationName";
    private String organizationName;

    public static final String JSON_PROPERTY_STATE_OR_PROVINCE_NAME = "stateOrProvinceName";
    private String stateOrProvinceName;

    public CsrMetadataSubject() {
    }

    public CsrMetadataSubject commonName(String commonName) {

        this.commonName = commonName;
        return this;
    }

    /**
     * Common name of the subject
     *
     * @return commonName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "SP Issuer", value = "Common name of the subject")
    @JsonProperty(JSON_PROPERTY_COMMON_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCommonName() {
        return commonName;
    }

    @JsonProperty(JSON_PROPERTY_COMMON_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public CsrMetadataSubject countryName(String countryName) {

        this.countryName = countryName;
        return this;
    }

    /**
     * Country name or code
     *
     * @return countryName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "US", value = "Country name or code")
    @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCountryName() {
        return countryName;
    }

    @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public CsrMetadataSubject localityName(String localityName) {

        this.localityName = localityName;
        return this;
    }

    /**
     * Locality (city) name
     *
     * @return localityName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "San Francisco", value = "Locality (city) name")
    @JsonProperty(JSON_PROPERTY_LOCALITY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLocalityName() {
        return localityName;
    }

    @JsonProperty(JSON_PROPERTY_LOCALITY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocalityName(String localityName) {
        this.localityName = localityName;
    }

    public CsrMetadataSubject organizationalUnitName(String organizationalUnitName) {

        this.organizationalUnitName = organizationalUnitName;
        return this;
    }

    /**
     * Name of the smaller organization, for example, the department or the division
     *
     * @return organizationalUnitName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Dev", value = "Name of the smaller organization, for example, the department or the division")
    @JsonProperty(JSON_PROPERTY_ORGANIZATIONAL_UNIT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrganizationalUnitName() {
        return organizationalUnitName;
    }

    @JsonProperty(JSON_PROPERTY_ORGANIZATIONAL_UNIT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrganizationalUnitName(String organizationalUnitName) {
        this.organizationalUnitName = organizationalUnitName;
    }

    public CsrMetadataSubject organizationName(String organizationName) {

        this.organizationName = organizationName;
        return this;
    }

    /**
     * Large organization name
     *
     * @return organizationName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Okta, Inc.", value = "Large organization name")
    @JsonProperty(JSON_PROPERTY_ORGANIZATION_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrganizationName() {
        return organizationName;
    }

    @JsonProperty(JSON_PROPERTY_ORGANIZATION_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public CsrMetadataSubject stateOrProvinceName(String stateOrProvinceName) {

        this.stateOrProvinceName = stateOrProvinceName;
        return this;
    }

    /**
     * State or province name
     *
     * @return stateOrProvinceName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "California", value = "State or province name")
    @JsonProperty(JSON_PROPERTY_STATE_OR_PROVINCE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getStateOrProvinceName() {
        return stateOrProvinceName;
    }

    @JsonProperty(JSON_PROPERTY_STATE_OR_PROVINCE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStateOrProvinceName(String stateOrProvinceName) {
        this.stateOrProvinceName = stateOrProvinceName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CsrMetadataSubject csrMetadataSubject = (CsrMetadataSubject) o;
        return Objects.equals(this.commonName, csrMetadataSubject.commonName)
                && Objects.equals(this.countryName, csrMetadataSubject.countryName)
                && Objects.equals(this.localityName, csrMetadataSubject.localityName)
                && Objects.equals(this.organizationalUnitName, csrMetadataSubject.organizationalUnitName)
                && Objects.equals(this.organizationName, csrMetadataSubject.organizationName)
                && Objects.equals(this.stateOrProvinceName, csrMetadataSubject.stateOrProvinceName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(commonName, countryName, localityName, organizationalUnitName, organizationName,
                stateOrProvinceName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CsrMetadataSubject {\n");
        sb.append("    commonName: ").append(toIndentedString(commonName)).append("\n");
        sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
        sb.append("    localityName: ").append(toIndentedString(localityName)).append("\n");
        sb.append("    organizationalUnitName: ").append(toIndentedString(organizationalUnitName)).append("\n");
        sb.append("    organizationName: ").append(toIndentedString(organizationName)).append("\n");
        sb.append("    stateOrProvinceName: ").append(toIndentedString(stateOrProvinceName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
