package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.LinksCustomRoleResponse;
import com.okta.sdk.resource.model.RoleAssignmentType;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CustomRole
 */
@JsonPropertyOrder({ CustomRole.JSON_PROPERTY_ASSIGNMENT_TYPE, CustomRole.JSON_PROPERTY_CREATED,
        CustomRole.JSON_PROPERTY_ID, CustomRole.JSON_PROPERTY_LABEL, CustomRole.JSON_PROPERTY_LAST_UPDATED,
        CustomRole.JSON_PROPERTY_RESOURCE_SET, CustomRole.JSON_PROPERTY_ROLE, CustomRole.JSON_PROPERTY_STATUS,
        CustomRole.JSON_PROPERTY_TYPE, CustomRole.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CustomRole implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ASSIGNMENT_TYPE = "assignmentType";
    private RoleAssignmentType assignmentType;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_RESOURCE_SET = "resource-set";
    private String resourceSet;

    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    /**
     * CUSTOM for a custom role
     */
    public enum TypeEnum {
        CUSTOM(String.valueOf("CUSTOM")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksCustomRoleResponse links;

    public CustomRole() {
    }

    /*
     * @JsonCreator public CustomRole(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LABEL) String label,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_RESOURCE_SET) String resourceSet,
     *
     * @JsonProperty(JSON_PROPERTY_ROLE) String role ) { this(); this.created = created; this.id = id; this.label =
     * label; this.lastUpdated = lastUpdated; this.resourceSet = resourceSet; this.role = role; }
     */

    public CustomRole assignmentType(RoleAssignmentType assignmentType) {

        this.assignmentType = assignmentType;
        return this;
    }

    /**
     * Get assignmentType
     *
     * @return assignmentType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASSIGNMENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RoleAssignmentType getAssignmentType() {
        return assignmentType;
    }

    @JsonProperty(JSON_PROPERTY_ASSIGNMENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssignmentType(RoleAssignmentType assignmentType) {
        this.assignmentType = assignmentType;
    }

    /**
     * Timestamp when the object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Binding Object ID
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Binding Object ID")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Label for the custom role assignment
     *
     * @return label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Label for the custom role assignment")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }

    /**
     * Timestamp when the object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    /**
     * Resource Set ID
     *
     * @return resourceSet
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Resource Set ID")
    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getResourceSet() {
        return resourceSet;
    }

    /**
     * Custom Role ID
     *
     * @return role
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Custom Role ID")
    @JsonProperty(JSON_PROPERTY_ROLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRole() {
        return role;
    }

    public CustomRole status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public CustomRole type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * CUSTOM for a custom role
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "CUSTOM for a custom role")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CustomRole links(LinksCustomRoleResponse links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksCustomRoleResponse getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksCustomRoleResponse links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CustomRole customRole = (CustomRole) o;
        return Objects.equals(this.assignmentType, customRole.assignmentType)
                && Objects.equals(this.created, customRole.created) && Objects.equals(this.id, customRole.id)
                && Objects.equals(this.label, customRole.label)
                && Objects.equals(this.lastUpdated, customRole.lastUpdated)
                && Objects.equals(this.resourceSet, customRole.resourceSet)
                && Objects.equals(this.role, customRole.role) && Objects.equals(this.status, customRole.status)
                && Objects.equals(this.type, customRole.type) && Objects.equals(this.links, customRole.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(assignmentType, created, id, label, lastUpdated, resourceSet, role, status, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomRole {\n");
        sb.append("    assignmentType: ").append(toIndentedString(assignmentType)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    resourceSet: ").append(toIndentedString(resourceSet)).append("\n");
        sb.append("    role: ").append(toIndentedString(role)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
