package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Variant for the Okta End-User Dashboard. You can publish a theme for end-user dashboard with different combinations
 * of assets. Variants are preset combinations of those assets.
 */
public enum EndUserDashboardTouchPointVariant {

    FULL_THEME("FULL_THEME"),

    LOGO_ON_FULL_WHITE_BACKGROUND("LOGO_ON_FULL_WHITE_BACKGROUND"),

    OKTA_DEFAULT("OKTA_DEFAULT"),

    WHITE_LOGO_BACKGROUND("WHITE_LOGO_BACKGROUND"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    EndUserDashboardTouchPointVariant(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static EndUserDashboardTouchPointVariant fromValue(String value) {
        for (EndUserDashboardTouchPointVariant b : EndUserDashboardTouchPointVariant.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
