package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IPServiceCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle
 * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;IP services, such as a proxy or VPN, to include or
 * exclude for an Enhanced Dynamic Network Zone
 */
@ApiModel(description = "<div class=\"x-lifecycle-container\"><x-lifecycle class=\"ea\"></x-lifecycle></div>IP services, such as a proxy or VPN, to include or exclude for an Enhanced Dynamic Network Zone")
@JsonPropertyOrder({ EnhancedDynamicNetworkZoneAllOfIpServiceCategories.JSON_PROPERTY_INCLUDE,
        EnhancedDynamicNetworkZoneAllOfIpServiceCategories.JSON_PROPERTY_EXCLUDE })
@JsonTypeName("EnhancedDynamicNetworkZone_allOf_ipServiceCategories")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EnhancedDynamicNetworkZoneAllOfIpServiceCategories implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<IPServiceCategory> include = null;

    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<IPServiceCategory> exclude = null;

    public EnhancedDynamicNetworkZoneAllOfIpServiceCategories() {
    }

    public EnhancedDynamicNetworkZoneAllOfIpServiceCategories include(List<IPServiceCategory> include) {

        this.include = include;
        return this;
    }

    public EnhancedDynamicNetworkZoneAllOfIpServiceCategories addincludeItem(IPServiceCategory includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<>();
        }
        this.include.add(includeItem);
        return this;
    }

    /**
     * IP services to include for an Enhanced Dynamic Network Zone
     *
     * @return include
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "IP services to include for an Enhanced Dynamic Network Zone")
    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<IPServiceCategory> getInclude() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<IPServiceCategory> include) {
        this.include = include;
    }

    public EnhancedDynamicNetworkZoneAllOfIpServiceCategories exclude(List<IPServiceCategory> exclude) {

        this.exclude = exclude;
        return this;
    }

    public EnhancedDynamicNetworkZoneAllOfIpServiceCategories addexcludeItem(IPServiceCategory excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    /**
     * IP services to exclude for an Enhanced Dynamic Network Zone
     *
     * @return exclude
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "IP services to exclude for an Enhanced Dynamic Network Zone")
    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<IPServiceCategory> getExclude() {
        return exclude;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(List<IPServiceCategory> exclude) {
        this.exclude = exclude;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnhancedDynamicNetworkZoneAllOfIpServiceCategories enhancedDynamicNetworkZoneAllOfIpServiceCategories = (EnhancedDynamicNetworkZoneAllOfIpServiceCategories) o;
        return Objects.equals(this.include, enhancedDynamicNetworkZoneAllOfIpServiceCategories.include)
                && Objects.equals(this.exclude, enhancedDynamicNetworkZoneAllOfIpServiceCategories.exclude);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(include, exclude);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnhancedDynamicNetworkZoneAllOfIpServiceCategories {\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
