package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EventHookChannel;
import com.okta.sdk.resource.model.EventHookLinks;
import com.okta.sdk.resource.model.EventHookVerificationStatus;
import com.okta.sdk.resource.model.EventSubscriptions;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EventHook
 */
@JsonPropertyOrder({ EventHook.JSON_PROPERTY_CHANNEL, EventHook.JSON_PROPERTY_CREATED,
        EventHook.JSON_PROPERTY_CREATED_BY, EventHook.JSON_PROPERTY_DESCRIPTION, EventHook.JSON_PROPERTY_EVENTS,
        EventHook.JSON_PROPERTY_ID, EventHook.JSON_PROPERTY_LAST_UPDATED, EventHook.JSON_PROPERTY_NAME,
        EventHook.JSON_PROPERTY_STATUS, EventHook.JSON_PROPERTY_VERIFICATION_STATUS, EventHook.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EventHook implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CHANNEL = "channel";
    private EventHookChannel channel;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_EVENTS = "events";
    private EventSubscriptions events;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    /**
     * Status of the event hook
     */
    public enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),

        INACTIVE(String.valueOf("INACTIVE")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private EventHookVerificationStatus verificationStatus;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private EventHookLinks links;

    public EventHook() {
    }

    /*
     * @JsonCreator public EventHook(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_BY) String createdBy,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_STATUS) StatusEnum status ) { this(); this.created = created; this.createdBy =
     * createdBy; this.id = id; this.lastUpdated = lastUpdated; this.status = status; }
     */

    public EventHook channel(EventHookChannel channel) {

        this.channel = channel;
        return this;
    }

    /**
     * Get channel
     *
     * @return channel
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_CHANNEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public EventHookChannel getChannel() {
        return channel;
    }

    @JsonProperty(JSON_PROPERTY_CHANNEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setChannel(EventHookChannel channel) {
        this.channel = channel;
    }

    /**
     * Timestamp of the event hook creation
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp of the event hook creation")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * The ID of the user who created the event hook
     *
     * @return createdBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the user who created the event hook")
    @JsonProperty(JSON_PROPERTY_CREATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedBy() {
        return createdBy;
    }

    public EventHook description(String description) {
        this.description = JsonNullable.<String> of(description);

        return this;
    }

    /**
     * Description of the event hook
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the event hook")
    @JsonIgnore

    public String getDescription() {
        return description.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getDescription_JsonNullable() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.<String> of(description);
    }

    public EventHook events(EventSubscriptions events) {

        this.events = events;
        return this;
    }

    /**
     * Get events
     *
     * @return events
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_EVENTS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public EventSubscriptions getEvents() {
        return events;
    }

    @JsonProperty(JSON_PROPERTY_EVENTS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEvents(EventSubscriptions events) {
        this.events = events;
    }

    /**
     * Unique key for the event hook
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique key for the event hook")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Date of the last event hook update
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Date of the last event hook update")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public EventHook name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Display name for the event hook
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Display name for the event hook")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Status of the event hook
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Status of the event hook")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    public EventHook verificationStatus(EventHookVerificationStatus verificationStatus) {

        this.verificationStatus = verificationStatus;
        return this;
    }

    /**
     * Get verificationStatus
     *
     * @return verificationStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EventHookVerificationStatus getVerificationStatus() {
        return verificationStatus;
    }

    @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationStatus(EventHookVerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public EventHook links(EventHookLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EventHookLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(EventHookLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EventHook eventHook = (EventHook) o;
        return Objects.equals(this.channel, eventHook.channel) && Objects.equals(this.created, eventHook.created)
                && Objects.equals(this.createdBy, eventHook.createdBy)
                && equalsNullable(this.description, eventHook.description)
                && Objects.equals(this.events, eventHook.events) && Objects.equals(this.id, eventHook.id)
                && Objects.equals(this.lastUpdated, eventHook.lastUpdated) && Objects.equals(this.name, eventHook.name)
                && Objects.equals(this.status, eventHook.status)
                && Objects.equals(this.verificationStatus, eventHook.verificationStatus)
                && Objects.equals(this.links, eventHook.links);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(channel, created, createdBy, hashCodeNullable(description), events, id, lastUpdated, name,
                status, verificationStatus, links);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventHook {\n");
        sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    events: ").append(toIndentedString(events)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    verificationStatus: ").append(toIndentedString(verificationStatus)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
