package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EventHookChannelConfig;
import com.okta.sdk.resource.model.EventHookChannelType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EventHookChannel
 */
@JsonPropertyOrder({ EventHookChannel.JSON_PROPERTY_CONFIG, EventHookChannel.JSON_PROPERTY_TYPE,
        EventHookChannel.JSON_PROPERTY_VERSION })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EventHookChannel implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONFIG = "config";
    private EventHookChannelConfig config;

    public static final String JSON_PROPERTY_TYPE = "type";
    private EventHookChannelType type;

    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;

    public EventHookChannel() {
    }

    public EventHookChannel config(EventHookChannelConfig config) {

        this.config = config;
        return this;
    }

    /**
     * Get config
     *
     * @return config
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_CONFIG)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public EventHookChannelConfig getConfig() {
        return config;
    }

    @JsonProperty(JSON_PROPERTY_CONFIG)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setConfig(EventHookChannelConfig config) {
        this.config = config;
    }

    public EventHookChannel type(EventHookChannelType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public EventHookChannelType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(EventHookChannelType type) {
        this.type = type;
    }

    public EventHookChannel version(String version) {

        this.version = version;
        return this;
    }

    /**
     * Version of the channel. Currently the only supported version is &#x60;1.0.0&#x60;&#x60;.
     *
     * @return version
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Version of the channel. Currently the only supported version is `1.0.0``.")
    @JsonProperty(JSON_PROPERTY_VERSION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getVersion() {
        return version;
    }

    @JsonProperty(JSON_PROPERTY_VERSION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EventHookChannel eventHookChannel = (EventHookChannel) o;
        return Objects.equals(this.config, eventHookChannel.config) && Objects.equals(this.type, eventHookChannel.type)
                && Objects.equals(this.version, eventHookChannel.version);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(config, type, version);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventHookChannel {\n");
        sb.append("    config: ").append(toIndentedString(config)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    version: ").append(toIndentedString(version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
