package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EventHookChannelConfigAuthSchemeType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The authentication scheme used for this request. To use Basic Auth for authentication, set &#x60;type&#x60; to
 * &#x60;HEADER&#x60;, &#x60;key&#x60; to &#x60;Authorization&#x60;, and &#x60;value&#x60; to the Base64-encoded string
 * of \&quot;username:password\&quot;. Ensure that you include the scheme (including space) as part of the
 * &#x60;value&#x60; parameter. For example, &#x60;Basic YWRtaW46c3VwZXJzZWNyZXQ&#x3D;&#x60;.
 */
@ApiModel(description = "The authentication scheme used for this request.  To use Basic Auth for authentication, set `type` to `HEADER`, `key` to `Authorization`, and `value` to the Base64-encoded string of \"username:password\". Ensure that you include the scheme (including space) as part of the `value` parameter. For example, `Basic YWRtaW46c3VwZXJzZWNyZXQ=`.")
@JsonPropertyOrder({ EventHookChannelConfigAuthScheme.JSON_PROPERTY_KEY,
        EventHookChannelConfigAuthScheme.JSON_PROPERTY_TYPE, EventHookChannelConfigAuthScheme.JSON_PROPERTY_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EventHookChannelConfigAuthScheme implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_KEY = "key";
    private String key;

    public static final String JSON_PROPERTY_TYPE = "type";
    private EventHookChannelConfigAuthSchemeType type;

    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public EventHookChannelConfigAuthScheme() {
    }

    public EventHookChannelConfigAuthScheme key(String key) {

        this.key = key;
        return this;
    }

    /**
     * The name for the authorization header
     *
     * @return key
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name for the authorization header")
    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKey() {
        return key;
    }

    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKey(String key) {
        this.key = key;
    }

    public EventHookChannelConfigAuthScheme type(EventHookChannelConfigAuthSchemeType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EventHookChannelConfigAuthSchemeType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(EventHookChannelConfigAuthSchemeType type) {
        this.type = type;
    }

    public EventHookChannelConfigAuthScheme value(String value) {

        this.value = value;
        return this;
    }

    /**
     * The header value. This secret key is passed to your external service endpoint for security verification. This
     * property is not returned in the response.
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The header value. This secret key is passed to your external service endpoint for security verification. This property is not returned in the response.")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EventHookChannelConfigAuthScheme eventHookChannelConfigAuthScheme = (EventHookChannelConfigAuthScheme) o;
        return Objects.equals(this.key, eventHookChannelConfigAuthScheme.key)
                && Objects.equals(this.type, eventHookChannelConfigAuthScheme.type)
                && Objects.equals(this.value, eventHookChannelConfigAuthScheme.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, type, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventHookChannelConfigAuthScheme {\n");
        sb.append("    key: ").append(toIndentedString(key)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
