package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PatchAction;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The update action
 */
@ApiModel(description = "The update action")
@JsonPropertyOrder({ JsonPatchOperation.JSON_PROPERTY_OP, JsonPatchOperation.JSON_PROPERTY_PATH,
        JsonPatchOperation.JSON_PROPERTY_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class JsonPatchOperation implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_OP = "op";
    private PatchAction op;

    public static final String JSON_PROPERTY_PATH = "path";
    private String path;

    public static final String JSON_PROPERTY_VALUE = "value";
    private Object value;

    public JsonPatchOperation() {
    }

    public JsonPatchOperation op(PatchAction op) {

        this.op = op;
        return this;
    }

    /**
     * Get op
     *
     * @return op
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PatchAction getOp() {
        return op;
    }

    @JsonProperty(JSON_PROPERTY_OP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOp(PatchAction op) {
        this.op = op;
    }

    public JsonPatchOperation path(String path) {

        this.path = path;
        return this;
    }

    /**
     * The resource path of the attribute to update
     *
     * @return path
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The resource path of the attribute to update")
    @JsonProperty(JSON_PROPERTY_PATH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPath() {
        return path;
    }

    @JsonProperty(JSON_PROPERTY_PATH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPath(String path) {
        this.path = path;
    }

    public JsonPatchOperation value(Object value) {

        this.value = value;
        return this;
    }

    /**
     * The update operation value
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The update operation value")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JsonPatchOperation jsonPatchOperation = (JsonPatchOperation) o;
        return Objects.equals(this.op, jsonPatchOperation.op) && Objects.equals(this.path, jsonPatchOperation.path)
                && Objects.equals(this.value, jsonPatchOperation.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(op, path, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonPatchOperation {\n");
        sb.append("    op: ").append(toIndentedString(op)).append("\n");
        sb.append("    path: ").append(toIndentedString(path)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
