package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.JsonWebKeyStatus;
import com.okta.sdk.resource.model.JsonWebKeyType;
import com.okta.sdk.resource.model.JsonWebKeyUse;
import com.okta.sdk.resource.model.SchemasJsonWebKey;
import com.okta.sdk.resource.model.SigningAlgorithm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * JsonWebKeyEC
 */
@JsonPropertyOrder({ JsonWebKeyEC.JSON_PROPERTY_X, JsonWebKeyEC.JSON_PROPERTY_Y })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "kty", visible = true, defaultImpl = JsonWebKeyEC.class)

public class JsonWebKeyEC extends SchemasJsonWebKey implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_X = "x";
    private String x;

    public static final String JSON_PROPERTY_Y = "y";
    private String y;

    public JsonWebKeyEC() {
    }

    public JsonWebKeyEC x(String x) {

        this.x = x;
        return this;
    }

    /**
     * The public x coordinate for the elliptic curve point
     *
     * @return x
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The public x coordinate for the elliptic curve point")
    @JsonProperty(JSON_PROPERTY_X)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getX() {
        return x;
    }

    @JsonProperty(JSON_PROPERTY_X)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setX(String x) {
        this.x = x;
    }

    public JsonWebKeyEC y(String y) {

        this.y = y;
        return this;
    }

    /**
     * The public y coordinate for the elliptic curve point
     *
     * @return y
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The public y coordinate for the elliptic curve point")
    @JsonProperty(JSON_PROPERTY_Y)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getY() {
        return y;
    }

    @JsonProperty(JSON_PROPERTY_Y)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setY(String y) {
        this.y = y;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JsonWebKeyEC jsonWebKeyEC = (JsonWebKeyEC) o;
        return Objects.equals(this.x, jsonWebKeyEC.x) && Objects.equals(this.y, jsonWebKeyEC.y);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(x, y, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonWebKeyEC {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    x: ").append(toIndentedString(x)).append("\n");
        sb.append("    y: ").append(toIndentedString(y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
