package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.ProfileMappingSource;
import com.okta.sdk.resource.model.ProfileMappingTarget;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A collection of the profile mappings that include a subset of the profile mapping object&#39;s properties. The
 * Profile Mapping object describes a mapping between an Okta User&#39;s and an App User&#39;s properties using [JSON
 * Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04). &gt; **Note:** Same type
 * source/target mappings aren&#39;t supported by this API. Profile mappings must either be Okta-&gt;App or
 * App-&gt;Okta.
 */
@ApiModel(description = "A collection of the profile mappings that include a subset of the profile mapping object's properties. The Profile Mapping object describes a mapping between an Okta User's and an App User's properties using [JSON Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04).  > **Note:** Same type source/target mappings aren't supported by this API. Profile mappings must either be Okta->App or App->Okta.")
@JsonPropertyOrder({ ListProfileMappings.JSON_PROPERTY_ID, ListProfileMappings.JSON_PROPERTY_SOURCE,
        ListProfileMappings.JSON_PROPERTY_TARGET, ListProfileMappings.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ListProfileMappings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_SOURCE = "source";
    private ProfileMappingSource source;

    public static final String JSON_PROPERTY_TARGET = "target";
    private ProfileMappingTarget target;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public ListProfileMappings() {
    }

    /*
     * @JsonCreator public ListProfileMappings(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id ) { this(); this.id = id; }
     */

    /**
     * Unique identifier for profile mapping
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for profile mapping")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public ListProfileMappings source(ProfileMappingSource source) {

        this.source = source;
        return this;
    }

    /**
     * Get source
     *
     * @return source
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProfileMappingSource getSource() {
        return source;
    }

    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSource(ProfileMappingSource source) {
        this.source = source;
    }

    public ListProfileMappings target(ProfileMappingTarget target) {

        this.target = target;
        return this;
    }

    /**
     * Get target
     *
     * @return target
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TARGET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProfileMappingTarget getTarget() {
        return target;
    }

    @JsonProperty(JSON_PROPERTY_TARGET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTarget(ProfileMappingTarget target) {
        this.target = target;
    }

    public ListProfileMappings links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListProfileMappings listProfileMappings = (ListProfileMappings) o;
        return Objects.equals(this.id, listProfileMappings.id)
                && Objects.equals(this.source, listProfileMappings.source)
                && Objects.equals(this.target, listProfileMappings.target)
                && Objects.equals(this.links, listProfileMappings.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, source, target, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListProfileMappings {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    source: ").append(toIndentedString(source)).append("\n");
        sb.append("    target: ").append(toIndentedString(target)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
