package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The &#x60;securityContext&#x60; object provides security information that is directly related to the evaluation of
 * the event&#39;s IP reputation. IP reputation is a trustworthiness rating that evaluates how likely a sender is to be
 * malicious and is based on the sender&#39;s IP address. As the name implies, the &#x60;securityContext&#x60; object is
 * useful for security applications-flagging and inspecting suspicious events.
 */
@ApiModel(description = "The `securityContext` object provides security information that is directly related to the evaluation of the event's IP reputation. IP reputation is a trustworthiness rating that evaluates how likely a sender is to be malicious and is based on the sender's IP address. As the name implies, the `securityContext` object is useful for security applications-flagging and inspecting suspicious events.")
@JsonPropertyOrder({ LogSecurityContext.JSON_PROPERTY_AS_NUMBER, LogSecurityContext.JSON_PROPERTY_AS_ORG,
        LogSecurityContext.JSON_PROPERTY_DOMAIN, LogSecurityContext.JSON_PROPERTY_ISP,
        LogSecurityContext.JSON_PROPERTY_IS_PROXY })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LogSecurityContext implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AS_NUMBER = "asNumber";
    private Integer asNumber;

    public static final String JSON_PROPERTY_AS_ORG = "asOrg";
    private String asOrg;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public static final String JSON_PROPERTY_ISP = "isp";
    private String isp;

    public static final String JSON_PROPERTY_IS_PROXY = "isProxy";
    private Boolean isProxy;

    public LogSecurityContext() {
    }

    /*
     * @JsonCreator public LogSecurityContext(
     *
     * @JsonProperty(JSON_PROPERTY_AS_NUMBER) Integer asNumber,
     *
     * @JsonProperty(JSON_PROPERTY_AS_ORG) String asOrg,
     *
     * @JsonProperty(JSON_PROPERTY_DOMAIN) String domain,
     *
     * @JsonProperty(JSON_PROPERTY_ISP) String isp,
     *
     * @JsonProperty(JSON_PROPERTY_IS_PROXY) Boolean isProxy ) { this(); this.asNumber = asNumber; this.asOrg = asOrg;
     * this.domain = domain; this.isp = isp; this.isProxy = isProxy; }
     */

    /**
     * The [Autonomous system](https://docs.telemetry.mozilla.org/datasets/other/asn_aggregates/reference) number
     * that&#39;s associated with the autonomous system the event request was sourced to
     *
     * @return asNumber
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The [Autonomous system](https://docs.telemetry.mozilla.org/datasets/other/asn_aggregates/reference) number that's associated with the autonomous system the event request was sourced to")
    @JsonProperty(JSON_PROPERTY_AS_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getAsNumber() {
        return asNumber;
    }

    /**
     * The organization that is associated with the autonomous system that the event request is sourced to
     *
     * @return asOrg
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The organization that is associated with the autonomous system that the event request is sourced to")
    @JsonProperty(JSON_PROPERTY_AS_ORG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAsOrg() {
        return asOrg;
    }

    /**
     * The domain name that&#39;s associated with the IP address of the inbound event request
     *
     * @return domain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The domain name that's associated with the IP address of the inbound event request")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDomain() {
        return domain;
    }

    /**
     * The Internet service provider that&#39;s used to send the event&#39;s request
     *
     * @return isp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Internet service provider that's used to send the event's request")
    @JsonProperty(JSON_PROPERTY_ISP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIsp() {
        return isp;
    }

    /**
     * Specifies whether an event&#39;s request is from a known proxy
     *
     * @return isProxy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies whether an event's request is from a known proxy")
    @JsonProperty(JSON_PROPERTY_IS_PROXY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getIsProxy() {
        return isProxy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogSecurityContext logSecurityContext = (LogSecurityContext) o;
        return Objects.equals(this.asNumber, logSecurityContext.asNumber)
                && Objects.equals(this.asOrg, logSecurityContext.asOrg)
                && Objects.equals(this.domain, logSecurityContext.domain)
                && Objects.equals(this.isp, logSecurityContext.isp)
                && Objects.equals(this.isProxy, logSecurityContext.isProxy);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(asNumber, asOrg, domain, isp, isProxy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogSecurityContext {\n");
        sb.append("    asNumber: ").append(toIndentedString(asNumber)).append("\n");
        sb.append("    asOrg: ").append(toIndentedString(asOrg)).append("\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("    isp: ").append(toIndentedString(isp)).append("\n");
        sb.append("    isProxy: ").append(toIndentedString(isProxy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
