package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * LogStreamDeactivateLink
 */
@JsonPropertyOrder({ LogStreamDeactivateLink.JSON_PROPERTY_HREF, LogStreamDeactivateLink.JSON_PROPERTY_METHOD })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LogStreamDeactivateLink implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HREF = "href";
    private String href;

    /**
     * HTTP method allowed for the resource
     */
    public enum MethodEnum {
        GET(String.valueOf("GET")),

        POST(String.valueOf("POST")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;

    public LogStreamDeactivateLink() {
    }

    public LogStreamDeactivateLink href(String href) {

        this.href = href;
        return this;
    }

    /**
     * The URI of the resource
     *
     * @return href
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The URI of the resource")
    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getHref() {
        return href;
    }

    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setHref(String href) {
        this.href = href;
    }

    public LogStreamDeactivateLink method(MethodEnum method) {

        this.method = method;
        return this;
    }

    /**
     * HTTP method allowed for the resource
     *
     * @return method
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "HTTP method allowed for the resource")
    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public MethodEnum getMethod() {
        return method;
    }

    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogStreamDeactivateLink logStreamDeactivateLink = (LogStreamDeactivateLink) o;
        return Objects.equals(this.href, logStreamDeactivateLink.href)
                && Objects.equals(this.method, logStreamDeactivateLink.method);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(href, method);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStreamDeactivateLink {\n");
        sb.append("    href: ").append(toIndentedString(href)).append("\n");
        sb.append("    method: ").append(toIndentedString(method)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
