package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppResourceHrefObject;
import com.okta.sdk.resource.model.AuthorizationServerResourceHrefObject;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import com.okta.sdk.resource.model.OAuth2RefreshTokenLinksAllOfRevoke;
import com.okta.sdk.resource.model.UserResourceHrefObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2RefreshTokenLinks
 */
@JsonPropertyOrder({ OAuth2RefreshTokenLinks.JSON_PROPERTY_SELF, OAuth2RefreshTokenLinks.JSON_PROPERTY_APP,
        OAuth2RefreshTokenLinks.JSON_PROPERTY_REVOKE, OAuth2RefreshTokenLinks.JSON_PROPERTY_CLIENT,
        OAuth2RefreshTokenLinks.JSON_PROPERTY_USER, OAuth2RefreshTokenLinks.JSON_PROPERTY_AUTHORIZATION_SERVER })
@JsonTypeName("OAuth2RefreshToken__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OAuth2RefreshTokenLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_APP = "app";
    private AppResourceHrefObject app;

    public static final String JSON_PROPERTY_REVOKE = "revoke";
    private OAuth2RefreshTokenLinksAllOfRevoke revoke;

    public static final String JSON_PROPERTY_CLIENT = "client";
    private AppResourceHrefObject client;

    public static final String JSON_PROPERTY_USER = "user";
    private UserResourceHrefObject user;

    public static final String JSON_PROPERTY_AUTHORIZATION_SERVER = "authorizationServer";
    private AuthorizationServerResourceHrefObject authorizationServer;

    public OAuth2RefreshTokenLinks() {
    }

    public OAuth2RefreshTokenLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public OAuth2RefreshTokenLinks app(AppResourceHrefObject app) {

        this.app = app;
        return this;
    }

    /**
     * Link to the app resource
     *
     * @return app
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the app resource")
    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppResourceHrefObject getApp() {
        return app;
    }

    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApp(AppResourceHrefObject app) {
        this.app = app;
    }

    public OAuth2RefreshTokenLinks revoke(OAuth2RefreshTokenLinksAllOfRevoke revoke) {

        this.revoke = revoke;
        return this;
    }

    /**
     * Get revoke
     *
     * @return revoke
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REVOKE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2RefreshTokenLinksAllOfRevoke getRevoke() {
        return revoke;
    }

    @JsonProperty(JSON_PROPERTY_REVOKE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRevoke(OAuth2RefreshTokenLinksAllOfRevoke revoke) {
        this.revoke = revoke;
    }

    public OAuth2RefreshTokenLinks client(AppResourceHrefObject client) {

        this.client = client;
        return this;
    }

    /**
     * Link to the client resource
     *
     * @return client
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the client resource")
    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppResourceHrefObject getClient() {
        return client;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClient(AppResourceHrefObject client) {
        this.client = client;
    }

    public OAuth2RefreshTokenLinks user(UserResourceHrefObject user) {

        this.user = user;
        return this;
    }

    /**
     * Link to the user resource
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the user resource")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserResourceHrefObject getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(UserResourceHrefObject user) {
        this.user = user;
    }

    public OAuth2RefreshTokenLinks authorizationServer(AuthorizationServerResourceHrefObject authorizationServer) {

        this.authorizationServer = authorizationServer;
        return this;
    }

    /**
     * Link to the Token authorization server resource
     *
     * @return authorizationServer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the Token authorization server resource")
    @JsonProperty(JSON_PROPERTY_AUTHORIZATION_SERVER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerResourceHrefObject getAuthorizationServer() {
        return authorizationServer;
    }

    @JsonProperty(JSON_PROPERTY_AUTHORIZATION_SERVER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationServer(AuthorizationServerResourceHrefObject authorizationServer) {
        this.authorizationServer = authorizationServer;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2RefreshTokenLinks oauth2RefreshTokenLinks = (OAuth2RefreshTokenLinks) o;
        return Objects.equals(this.self, oauth2RefreshTokenLinks.self)
                && Objects.equals(this.app, oauth2RefreshTokenLinks.app)
                && Objects.equals(this.revoke, oauth2RefreshTokenLinks.revoke)
                && Objects.equals(this.client, oauth2RefreshTokenLinks.client)
                && Objects.equals(this.user, oauth2RefreshTokenLinks.user)
                && Objects.equals(this.authorizationServer, oauth2RefreshTokenLinks.authorizationServer);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, app, revoke, client, user, authorizationServer);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2RefreshTokenLinks {\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    app: ").append(toIndentedString(app)).append("\n");
        sb.append("    revoke: ").append(toIndentedString(revoke)).append("\n");
        sb.append("    client: ").append(toIndentedString(client)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("    authorizationServer: ").append(toIndentedString(authorizationServer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
