package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.OAuth2ScopeConsentType;
import com.okta.sdk.resource.model.OAuth2ScopeMetadataPublish;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2Scope
 */
@JsonPropertyOrder({ OAuth2Scope.JSON_PROPERTY_CONSENT, OAuth2Scope.JSON_PROPERTY_DEFAULT,
        OAuth2Scope.JSON_PROPERTY_DESCRIPTION, OAuth2Scope.JSON_PROPERTY_DISPLAY_NAME, OAuth2Scope.JSON_PROPERTY_ID,
        OAuth2Scope.JSON_PROPERTY_METADATA_PUBLISH, OAuth2Scope.JSON_PROPERTY_NAME, OAuth2Scope.JSON_PROPERTY_OPTIONAL,
        OAuth2Scope.JSON_PROPERTY_SYSTEM, OAuth2Scope.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OAuth2Scope implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONSENT = "consent";
    private OAuth2ScopeConsentType consent = OAuth2ScopeConsentType.IMPLICIT;

    public static final String JSON_PROPERTY_DEFAULT = "default";
    private Boolean _default = false;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_METADATA_PUBLISH = "metadataPublish";
    private OAuth2ScopeMetadataPublish metadataPublish = OAuth2ScopeMetadataPublish.NO_CLIENTS;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_OPTIONAL = "optional";
    private Boolean optional = false;

    public static final String JSON_PROPERTY_SYSTEM = "system";
    private Boolean system = false;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public OAuth2Scope() {
    }

    /*
     * @JsonCreator public OAuth2Scope(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id ) { this(); this.id = id; }
     */

    public OAuth2Scope consent(OAuth2ScopeConsentType consent) {

        this.consent = consent;
        return this;
    }

    /**
     * Get consent
     *
     * @return consent
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONSENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ScopeConsentType getConsent() {
        return consent;
    }

    @JsonProperty(JSON_PROPERTY_CONSENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConsent(OAuth2ScopeConsentType consent) {
        this.consent = consent;
    }

    public OAuth2Scope _default(Boolean _default) {

        this._default = _default;
        return this;
    }

    /**
     * Indicates if this Scope is a default scope
     *
     * @return _default
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if this Scope is a default scope")
    @JsonProperty(JSON_PROPERTY_DEFAULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getDefault() {
        return _default;
    }

    @JsonProperty(JSON_PROPERTY_DEFAULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public OAuth2Scope description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Scope
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the Scope")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public OAuth2Scope displayName(String displayName) {

        this.displayName = displayName;
        return this;
    }

    /**
     * Name of the end user displayed in a consent dialog
     *
     * @return displayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the end user displayed in a consent dialog")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDisplayName() {
        return displayName;
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * Scope object ID
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Scope object ID")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public OAuth2Scope metadataPublish(OAuth2ScopeMetadataPublish metadataPublish) {

        this.metadataPublish = metadataPublish;
        return this;
    }

    /**
     * Get metadataPublish
     *
     * @return metadataPublish
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_METADATA_PUBLISH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ScopeMetadataPublish getMetadataPublish() {
        return metadataPublish;
    }

    @JsonProperty(JSON_PROPERTY_METADATA_PUBLISH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMetadataPublish(OAuth2ScopeMetadataPublish metadataPublish) {
        this.metadataPublish = metadataPublish;
    }

    public OAuth2Scope name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Scope name
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Scope name")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public OAuth2Scope optional(Boolean optional) {

        this.optional = optional;
        return this;
    }

    /**
     * Indicates whether the Scope is optional. When set to &#x60;true&#x60;, the user can skip consent for the scope.
     *
     * @return optional
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the Scope is optional. When set to `true`, the user can skip consent for the scope.")
    @JsonProperty(JSON_PROPERTY_OPTIONAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getOptional() {
        return optional;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public OAuth2Scope system(Boolean system) {

        this.system = system;
        return this;
    }

    /**
     * Indicates if Okta created the Scope
     *
     * @return system
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if Okta created the Scope")
    @JsonProperty(JSON_PROPERTY_SYSTEM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSystem() {
        return system;
    }

    @JsonProperty(JSON_PROPERTY_SYSTEM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSystem(Boolean system) {
        this.system = system;
    }

    public OAuth2Scope links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2Scope oauth2Scope = (OAuth2Scope) o;
        return Objects.equals(this.consent, oauth2Scope.consent) && Objects.equals(this._default, oauth2Scope._default)
                && Objects.equals(this.description, oauth2Scope.description)
                && Objects.equals(this.displayName, oauth2Scope.displayName) && Objects.equals(this.id, oauth2Scope.id)
                && Objects.equals(this.metadataPublish, oauth2Scope.metadataPublish)
                && Objects.equals(this.name, oauth2Scope.name) && Objects.equals(this.optional, oauth2Scope.optional)
                && Objects.equals(this.system, oauth2Scope.system) && Objects.equals(this.links, oauth2Scope.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(consent, _default, description, displayName, id, metadataPublish, name, optional, system,
                links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Scope {\n");
        sb.append("    consent: ").append(toIndentedString(consent)).append("\n");
        sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    metadataPublish: ").append(toIndentedString(metadataPublish)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    optional: ").append(toIndentedString(optional)).append("\n");
        sb.append("    system: ").append(toIndentedString(system)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
