package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProtocolEndpointBinding;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Endpoint for getting identity information about the User. For more information on the &#x60;/userinfo&#x60; endpoint,
 * see [OpenID Connect](https://openid.net/specs/openid-connect-core-1_0.html#UserInfo).
 */
@ApiModel(description = "Endpoint for getting identity information about the User. For more information on the `/userinfo` endpoint, see [OpenID Connect](https://openid.net/specs/openid-connect-core-1_0.html#UserInfo).")
@JsonPropertyOrder({ OidcUserInfoEndpoint.JSON_PROPERTY_BINDING, OidcUserInfoEndpoint.JSON_PROPERTY_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OidcUserInfoEndpoint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BINDING = "binding";
    private ProtocolEndpointBinding binding;

    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public OidcUserInfoEndpoint() {
    }

    public OidcUserInfoEndpoint binding(ProtocolEndpointBinding binding) {

        this.binding = binding;
        return this;
    }

    /**
     * Get binding
     *
     * @return binding
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolEndpointBinding getBinding() {
        return binding;
    }

    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBinding(ProtocolEndpointBinding binding) {
        this.binding = binding;
    }

    public OidcUserInfoEndpoint url(String url) {

        this.url = url;
        return this;
    }

    /**
     * URL of the resource server&#39;s &#x60;/userinfo&#x60; endpoint
     *
     * @return url
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://idp.example.com/userinfo", value = "URL of the resource server's `/userinfo` endpoint")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OidcUserInfoEndpoint oidcUserInfoEndpoint = (OidcUserInfoEndpoint) o;
        return Objects.equals(this.binding, oidcUserInfoEndpoint.binding)
                && Objects.equals(this.url, oidcUserInfoEndpoint.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(binding, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OidcUserInfoEndpoint {\n");
        sb.append("    binding: ").append(toIndentedString(binding)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
