package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OktaSignOnPolicyFactorPromptMode;
import com.okta.sdk.resource.model.OktaSignOnPolicyRuleSignonPrimaryFactor;
import com.okta.sdk.resource.model.OktaSignOnPolicyRuleSignonSessionActions;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OktaSignOnPolicyRuleSignonActions
 */
@JsonPropertyOrder({ OktaSignOnPolicyRuleSignonActions.JSON_PROPERTY_ACCESS,
        OktaSignOnPolicyRuleSignonActions.JSON_PROPERTY_FACTOR_LIFETIME,
        OktaSignOnPolicyRuleSignonActions.JSON_PROPERTY_FACTOR_PROMPT_MODE,
        OktaSignOnPolicyRuleSignonActions.JSON_PROPERTY_PRIMARY_FACTOR,
        OktaSignOnPolicyRuleSignonActions.JSON_PROPERTY_REMEMBER_DEVICE_BY_DEFAULT,
        OktaSignOnPolicyRuleSignonActions.JSON_PROPERTY_REQUIRE_FACTOR,
        OktaSignOnPolicyRuleSignonActions.JSON_PROPERTY_SESSION })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OktaSignOnPolicyRuleSignonActions implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets access
     */
    public enum AccessEnum {
        ALLOW(String.valueOf("ALLOW")),

        DENY(String.valueOf("DENY")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        AccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static AccessEnum fromValue(String value) {
            for (AccessEnum b : AccessEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_ACCESS = "access";
    private AccessEnum access;

    public static final String JSON_PROPERTY_FACTOR_LIFETIME = "factorLifetime";
    private Integer factorLifetime;

    public static final String JSON_PROPERTY_FACTOR_PROMPT_MODE = "factorPromptMode";
    private OktaSignOnPolicyFactorPromptMode factorPromptMode;

    public static final String JSON_PROPERTY_PRIMARY_FACTOR = "primaryFactor";
    private OktaSignOnPolicyRuleSignonPrimaryFactor primaryFactor;

    public static final String JSON_PROPERTY_REMEMBER_DEVICE_BY_DEFAULT = "rememberDeviceByDefault";
    private Boolean rememberDeviceByDefault = false;

    public static final String JSON_PROPERTY_REQUIRE_FACTOR = "requireFactor";
    private Boolean requireFactor = false;

    public static final String JSON_PROPERTY_SESSION = "session";
    private OktaSignOnPolicyRuleSignonSessionActions session;

    public OktaSignOnPolicyRuleSignonActions() {
    }

    public OktaSignOnPolicyRuleSignonActions access(AccessEnum access) {

        this.access = access;
        return this;
    }

    /**
     * Get access
     *
     * @return access
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACCESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AccessEnum getAccess() {
        return access;
    }

    @JsonProperty(JSON_PROPERTY_ACCESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccess(AccessEnum access) {
        this.access = access;
    }

    public OktaSignOnPolicyRuleSignonActions factorLifetime(Integer factorLifetime) {

        this.factorLifetime = factorLifetime;
        return this;
    }

    /**
     * Interval of time that must elapse before the User is challenged for MFA, if the Factor prompt mode is set to
     * &#x60;SESSION&#x60; **Note:** Required only if &#x60;requireFactor&#x60; is &#x60;true&#x60;.
     *
     * @return factorLifetime
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Interval of time that must elapse before the User is challenged for MFA, if the Factor prompt mode is set to `SESSION`  **Note:** Required only if `requireFactor` is `true`. ")
    @JsonProperty(JSON_PROPERTY_FACTOR_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getFactorLifetime() {
        return factorLifetime;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorLifetime(Integer factorLifetime) {
        this.factorLifetime = factorLifetime;
    }

    public OktaSignOnPolicyRuleSignonActions factorPromptMode(OktaSignOnPolicyFactorPromptMode factorPromptMode) {

        this.factorPromptMode = factorPromptMode;
        return this;
    }

    /**
     * Get factorPromptMode
     *
     * @return factorPromptMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FACTOR_PROMPT_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OktaSignOnPolicyFactorPromptMode getFactorPromptMode() {
        return factorPromptMode;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_PROMPT_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorPromptMode(OktaSignOnPolicyFactorPromptMode factorPromptMode) {
        this.factorPromptMode = factorPromptMode;
    }

    public OktaSignOnPolicyRuleSignonActions primaryFactor(OktaSignOnPolicyRuleSignonPrimaryFactor primaryFactor) {

        this.primaryFactor = primaryFactor;
        return this;
    }

    /**
     * Get primaryFactor
     *
     * @return primaryFactor
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PRIMARY_FACTOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OktaSignOnPolicyRuleSignonPrimaryFactor getPrimaryFactor() {
        return primaryFactor;
    }

    @JsonProperty(JSON_PROPERTY_PRIMARY_FACTOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryFactor(OktaSignOnPolicyRuleSignonPrimaryFactor primaryFactor) {
        this.primaryFactor = primaryFactor;
    }

    public OktaSignOnPolicyRuleSignonActions rememberDeviceByDefault(Boolean rememberDeviceByDefault) {

        this.rememberDeviceByDefault = rememberDeviceByDefault;
        return this;
    }

    /**
     * Indicates if Okta should automatically remember the device
     *
     * @return rememberDeviceByDefault
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if Okta should automatically remember the device")
    @JsonProperty(JSON_PROPERTY_REMEMBER_DEVICE_BY_DEFAULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRememberDeviceByDefault() {
        return rememberDeviceByDefault;
    }

    @JsonProperty(JSON_PROPERTY_REMEMBER_DEVICE_BY_DEFAULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRememberDeviceByDefault(Boolean rememberDeviceByDefault) {
        this.rememberDeviceByDefault = rememberDeviceByDefault;
    }

    public OktaSignOnPolicyRuleSignonActions requireFactor(Boolean requireFactor) {

        this.requireFactor = requireFactor;
        return this;
    }

    /**
     * Indicates if multifactor authentication is required
     *
     * @return requireFactor
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if multifactor authentication is required")
    @JsonProperty(JSON_PROPERTY_REQUIRE_FACTOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRequireFactor() {
        return requireFactor;
    }

    @JsonProperty(JSON_PROPERTY_REQUIRE_FACTOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequireFactor(Boolean requireFactor) {
        this.requireFactor = requireFactor;
    }

    public OktaSignOnPolicyRuleSignonActions session(OktaSignOnPolicyRuleSignonSessionActions session) {

        this.session = session;
        return this;
    }

    /**
     * Get session
     *
     * @return session
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OktaSignOnPolicyRuleSignonSessionActions getSession() {
        return session;
    }

    @JsonProperty(JSON_PROPERTY_SESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSession(OktaSignOnPolicyRuleSignonSessionActions session) {
        this.session = session;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OktaSignOnPolicyRuleSignonActions oktaSignOnPolicyRuleSignonActions = (OktaSignOnPolicyRuleSignonActions) o;
        return Objects.equals(this.access, oktaSignOnPolicyRuleSignonActions.access)
                && Objects.equals(this.factorLifetime, oktaSignOnPolicyRuleSignonActions.factorLifetime)
                && Objects.equals(this.factorPromptMode, oktaSignOnPolicyRuleSignonActions.factorPromptMode)
                && Objects.equals(this.primaryFactor, oktaSignOnPolicyRuleSignonActions.primaryFactor)
                && Objects.equals(this.rememberDeviceByDefault,
                        oktaSignOnPolicyRuleSignonActions.rememberDeviceByDefault)
                && Objects.equals(this.requireFactor, oktaSignOnPolicyRuleSignonActions.requireFactor)
                && Objects.equals(this.session, oktaSignOnPolicyRuleSignonActions.session);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(access, factorLifetime, factorPromptMode, primaryFactor, rememberDeviceByDefault,
                requireFactor, session);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaSignOnPolicyRuleSignonActions {\n");
        sb.append("    access: ").append(toIndentedString(access)).append("\n");
        sb.append("    factorLifetime: ").append(toIndentedString(factorLifetime)).append("\n");
        sb.append("    factorPromptMode: ").append(toIndentedString(factorPromptMode)).append("\n");
        sb.append("    primaryFactor: ").append(toIndentedString(primaryFactor)).append("\n");
        sb.append("    rememberDeviceByDefault: ").append(toIndentedString(rememberDeviceByDefault)).append("\n");
        sb.append("    requireFactor: ").append(toIndentedString(requireFactor)).append("\n");
        sb.append("    session: ").append(toIndentedString(session)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
