package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; Indicates the primary factor used to establish a
 * session for the org. Supported values: &#x60;PASSWORD_IDP_ANY_FACTOR&#x60; (users can use any factor required by the
 * app authentication policy to establish a session), &#x60;PASSWORD_IDP&#x60; (users must always use a password to
 * establish a session). **Note:** Required only if &#x60;access&#x60; is set to &#x60;ALLOW&#x60;.
 */
public enum OktaSignOnPolicyRuleSignonPrimaryFactor {

    PASSWORD_IDP("PASSWORD_IDP"),

    PASSWORD_IDP_ANY_FACTOR("PASSWORD_IDP_ANY_FACTOR"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    OktaSignOnPolicyRuleSignonPrimaryFactor(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static OktaSignOnPolicyRuleSignonPrimaryFactor fromValue(String value) {
        for (OktaSignOnPolicyRuleSignonPrimaryFactor b : OktaSignOnPolicyRuleSignonPrimaryFactor.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
