package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgOktaCommunicationSettingLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OrgOktaCommunicationSetting
 */
@JsonPropertyOrder({ OrgOktaCommunicationSetting.JSON_PROPERTY_OPT_OUT_EMAIL_USERS,
        OrgOktaCommunicationSetting.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgOktaCommunicationSetting implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_OPT_OUT_EMAIL_USERS = "optOutEmailUsers";
    private Boolean optOutEmailUsers;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OrgOktaCommunicationSettingLinks links;

    public OrgOktaCommunicationSetting() {
    }

    /*
     * @JsonCreator public OrgOktaCommunicationSetting(
     *
     * @JsonProperty(JSON_PROPERTY_OPT_OUT_EMAIL_USERS) Boolean optOutEmailUsers ) { this(); this.optOutEmailUsers =
     * optOutEmailUsers; }
     */

    /**
     * Indicates whether org users receive Okta communication emails
     *
     * @return optOutEmailUsers
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether org users receive Okta communication emails")
    @JsonProperty(JSON_PROPERTY_OPT_OUT_EMAIL_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getOptOutEmailUsers() {
        return optOutEmailUsers;
    }

    public OrgOktaCommunicationSetting links(OrgOktaCommunicationSettingLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgOktaCommunicationSettingLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OrgOktaCommunicationSettingLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgOktaCommunicationSetting orgOktaCommunicationSetting = (OrgOktaCommunicationSetting) o;
        return Objects.equals(this.optOutEmailUsers, orgOktaCommunicationSetting.optOutEmailUsers)
                && Objects.equals(this.links, orgOktaCommunicationSetting.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(optOutEmailUsers, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgOktaCommunicationSetting {\n");
        sb.append("    optOutEmailUsers: ").append(toIndentedString(optOutEmailUsers)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
