package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgOktaSupportSetting;
import com.okta.sdk.resource.model.OrgOktaSupportSettingsObjLinks;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OrgOktaSupportSettingsObj
 */
@JsonPropertyOrder({ OrgOktaSupportSettingsObj.JSON_PROPERTY_EXPIRATION,
        OrgOktaSupportSettingsObj.JSON_PROPERTY_SUPPORT, OrgOktaSupportSettingsObj.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgOktaSupportSettingsObj implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private JsonNullable<OffsetDateTime> expiration = JsonNullable.<OffsetDateTime> undefined();

    public static final String JSON_PROPERTY_SUPPORT = "support";
    private OrgOktaSupportSetting support;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OrgOktaSupportSettingsObjLinks links;

    public OrgOktaSupportSettingsObj() {
    }

    /*
     * @JsonCreator public OrgOktaSupportSettingsObj(
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRATION) OffsetDateTime expiration ) { this(); this.expiration = expiration; }
     */

    /**
     * Expiration of Okta Support
     *
     * @return expiration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Expiration of Okta Support")
    @JsonIgnore

    public OffsetDateTime getExpiration() {

        if (expiration == null) {
            expiration = JsonNullable.<OffsetDateTime> undefined();
        }
        return expiration.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<OffsetDateTime> getExpiration_JsonNullable() {
        return expiration;
    }

    @JsonProperty(JSON_PROPERTY_EXPIRATION)
    private void setExpiration_JsonNullable(JsonNullable<OffsetDateTime> expiration) {
        this.expiration = expiration;
    }

    public OrgOktaSupportSettingsObj support(OrgOktaSupportSetting support) {

        this.support = support;
        return this;
    }

    /**
     * Get support
     *
     * @return support
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SUPPORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgOktaSupportSetting getSupport() {
        return support;
    }

    @JsonProperty(JSON_PROPERTY_SUPPORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSupport(OrgOktaSupportSetting support) {
        this.support = support;
    }

    public OrgOktaSupportSettingsObj links(OrgOktaSupportSettingsObjLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgOktaSupportSettingsObjLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OrgOktaSupportSettingsObjLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgOktaSupportSettingsObj orgOktaSupportSettingsObj = (OrgOktaSupportSettingsObj) o;
        return equalsNullable(this.expiration, orgOktaSupportSettingsObj.expiration)
                && Objects.equals(this.support, orgOktaSupportSettingsObj.support)
                && Objects.equals(this.links, orgOktaSupportSettingsObj.links);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(expiration), support, links);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgOktaSupportSettingsObj {\n");
        sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
        sb.append("    support: ").append(toIndentedString(support)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
