package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgTechnicalContactTypeLinksTechnical;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the org technical
 * Contact Type object using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the org technical Contact Type object using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ OrgTechnicalContactTypeLinks.JSON_PROPERTY_TECHNICAL })
@JsonTypeName("orgTechnicalContactType__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgTechnicalContactTypeLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TECHNICAL = "technical";
    private OrgTechnicalContactTypeLinksTechnical technical;

    public OrgTechnicalContactTypeLinks() {
    }

    public OrgTechnicalContactTypeLinks technical(OrgTechnicalContactTypeLinksTechnical technical) {

        this.technical = technical;
        return this;
    }

    /**
     * Get technical
     *
     * @return technical
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TECHNICAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgTechnicalContactTypeLinksTechnical getTechnical() {
        return technical;
    }

    @JsonProperty(JSON_PROPERTY_TECHNICAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTechnical(OrgTechnicalContactTypeLinksTechnical technical) {
        this.technical = technical;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgTechnicalContactTypeLinks orgTechnicalContactTypeLinks = (OrgTechnicalContactTypeLinks) o;
        return Objects.equals(this.technical, orgTechnicalContactTypeLinks.technical);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(technical);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgTechnicalContactTypeLinks {\n");
        sb.append("    technical: ").append(toIndentedString(technical)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
