package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Attributes used for processing AD Group membership update
 */
@ApiModel(description = "Attributes used for processing AD Group membership update")
@JsonPropertyOrder({ Parameters.JSON_PROPERTY_ACTION, Parameters.JSON_PROPERTY_ATTRIBUTE,
        Parameters.JSON_PROPERTY_VALUES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Parameters implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The update action to take
     */
    public enum ActionEnum {
        ADD(String.valueOf("ADD")),

        REMOVE(String.valueOf("REMOVE")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_ACTION = "action";
    private ActionEnum action;

    public static final String JSON_PROPERTY_ATTRIBUTE = "attribute";
    private String attribute;

    public static final String JSON_PROPERTY_VALUES = "values";
    private List<String> values = null;

    public Parameters() {
    }

    public Parameters action(ActionEnum action) {

        this.action = action;
        return this;
    }

    /**
     * The update action to take
     *
     * @return action
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The update action to take")
    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ActionEnum getAction() {
        return action;
    }

    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public Parameters attribute(String attribute) {

        this.attribute = attribute;
        return this;
    }

    /**
     * The attribute that tracks group memberships in AD. This should be &#x60;member&#x60; for AD.
     *
     * @return attribute
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The attribute that tracks group memberships in AD. This should be `member` for AD.")
    @JsonProperty(JSON_PROPERTY_ATTRIBUTE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAttribute() {
        return attribute;
    }

    @JsonProperty(JSON_PROPERTY_ATTRIBUTE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Parameters values(List<String> values) {

        this.values = values;
        return this;
    }

    public Parameters addvaluesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<>();
        }
        this.values.add(valuesItem);
        return this;
    }

    /**
     * List of user IDs whose group memberships to update
     *
     * @return values
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of user IDs whose group memberships to update")
    @JsonProperty(JSON_PROPERTY_VALUES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getValues() {
        return values;
    }

    @JsonProperty(JSON_PROPERTY_VALUES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<String> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Parameters parameters = (Parameters) o;
        return Objects.equals(this.action, parameters.action) && Objects.equals(this.attribute, parameters.attribute)
                && Objects.equals(this.values, parameters.values);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(action, attribute, values);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Parameters {\n");
        sb.append("    action: ").append(toIndentedString(action)).append("\n");
        sb.append("    attribute: ").append(toIndentedString(attribute)).append("\n");
        sb.append("    values: ").append(toIndentedString(values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
