package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * This object specifies the default action Okta is set to take. Okta takes this action if your external service sends
 * an empty HTTP 204 response. You can override the default action by returning a commands object in your response
 * specifying the action to take.
 */
@ApiModel(description = "This object specifies the default action Okta is set to take. Okta takes this action if your external service sends an empty HTTP 204 response. You can override the default action by returning a commands object in your response specifying the action to take.")
@JsonPropertyOrder({ PasswordImportRequestDataAction.JSON_PROPERTY_CREDENTIAL })
@JsonTypeName("PasswordImportRequestData_action")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PasswordImportRequestDataAction implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIAL = "credential";
    private String credential = "UNVERIFIED";

    public PasswordImportRequestDataAction() {
    }

    public PasswordImportRequestDataAction credential(String credential) {

        this.credential = credential;
        return this;
    }

    /**
     * The status of the user credential, either &#x60;UNVERIFIED&#x60; or &#x60;VERIFIED&#x60;
     *
     * @return credential
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The status of the user credential, either `UNVERIFIED` or `VERIFIED`")
    @JsonProperty(JSON_PROPERTY_CREDENTIAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCredential() {
        return credential;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredential(String credential) {
        this.credential = credential;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordImportRequestDataAction passwordImportRequestDataAction = (PasswordImportRequestDataAction) o;
        return Objects.equals(this.credential, passwordImportRequestDataAction.credential);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credential);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordImportRequestDataAction {\n");
        sb.append("    credential: ").append(toIndentedString(credential)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
