package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Determines the Okta User profile attribute match conditions for account linking and authentication of the transformed
 * IdP username
 */
public enum PolicySubjectMatchType {

    CUSTOM_ATTRIBUTE("CUSTOM_ATTRIBUTE"),

    EMAIL("EMAIL"),

    USERNAME("USERNAME"),

    USERNAME_OR_EMAIL("USERNAME_OR_EMAIL"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    PolicySubjectMatchType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static PolicySubjectMatchType fromValue(String value) {
        for (PolicySubjectMatchType b : PolicySubjectMatchType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
