package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PostAuthKeepMeSignedInPrompt
 */
@JsonPropertyOrder({ PostAuthKeepMeSignedInPrompt.JSON_PROPERTY_ACCEPT_BUTTON_TEXT,
        PostAuthKeepMeSignedInPrompt.JSON_PROPERTY_REJECT_BUTTON_TEXT,
        PostAuthKeepMeSignedInPrompt.JSON_PROPERTY_SUBTITLE, PostAuthKeepMeSignedInPrompt.JSON_PROPERTY_TITLE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PostAuthKeepMeSignedInPrompt implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACCEPT_BUTTON_TEXT = "acceptButtonText";
    private String acceptButtonText;

    public static final String JSON_PROPERTY_REJECT_BUTTON_TEXT = "rejectButtonText";
    private String rejectButtonText;

    public static final String JSON_PROPERTY_SUBTITLE = "subtitle";
    private String subtitle;

    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public PostAuthKeepMeSignedInPrompt() {
    }

    public PostAuthKeepMeSignedInPrompt acceptButtonText(String acceptButtonText) {

        this.acceptButtonText = acceptButtonText;
        return this;
    }

    /**
     * The label on the accept button when prompting for Stay signed in
     *
     * @return acceptButtonText
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label on the accept button when prompting for Stay signed in")
    @JsonProperty(JSON_PROPERTY_ACCEPT_BUTTON_TEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAcceptButtonText() {
        return acceptButtonText;
    }

    @JsonProperty(JSON_PROPERTY_ACCEPT_BUTTON_TEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptButtonText(String acceptButtonText) {
        this.acceptButtonText = acceptButtonText;
    }

    public PostAuthKeepMeSignedInPrompt rejectButtonText(String rejectButtonText) {

        this.rejectButtonText = rejectButtonText;
        return this;
    }

    /**
     * The label on the reject button when prompting for Stay signed in
     *
     * @return rejectButtonText
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The label on the reject button when prompting for Stay signed in")
    @JsonProperty(JSON_PROPERTY_REJECT_BUTTON_TEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRejectButtonText() {
        return rejectButtonText;
    }

    @JsonProperty(JSON_PROPERTY_REJECT_BUTTON_TEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRejectButtonText(String rejectButtonText) {
        this.rejectButtonText = rejectButtonText;
    }

    public PostAuthKeepMeSignedInPrompt subtitle(String subtitle) {

        this.subtitle = subtitle;
        return this;
    }

    /**
     * The subtitle on the Sign-In Widget when prompting for Stay signed in
     *
     * @return subtitle
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The subtitle on the Sign-In Widget when prompting for Stay signed in")
    @JsonProperty(JSON_PROPERTY_SUBTITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSubtitle() {
        return subtitle;
    }

    @JsonProperty(JSON_PROPERTY_SUBTITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public PostAuthKeepMeSignedInPrompt title(String title) {

        this.title = title;
        return this;
    }

    /**
     * The title on the Sign-In Widget when prompting for Stay signed in
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The title on the Sign-In Widget when prompting for Stay signed in")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PostAuthKeepMeSignedInPrompt postAuthKeepMeSignedInPrompt = (PostAuthKeepMeSignedInPrompt) o;
        return Objects.equals(this.acceptButtonText, postAuthKeepMeSignedInPrompt.acceptButtonText)
                && Objects.equals(this.rejectButtonText, postAuthKeepMeSignedInPrompt.rejectButtonText)
                && Objects.equals(this.subtitle, postAuthKeepMeSignedInPrompt.subtitle)
                && Objects.equals(this.title, postAuthKeepMeSignedInPrompt.title);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(acceptButtonText, rejectButtonText, subtitle, title);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostAuthKeepMeSignedInPrompt {\n");
        sb.append("    acceptButtonText: ").append(toIndentedString(acceptButtonText)).append("\n");
        sb.append("    rejectButtonText: ").append(toIndentedString(rejectButtonText)).append("\n");
        sb.append("    subtitle: ").append(toIndentedString(subtitle)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
