package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Update request for a privileged resource
 */
@ApiModel(description = "Update request for a privileged resource")
@JsonPropertyOrder({ PrivilegedResourceUpdateRequest.JSON_PROPERTY_PROFILE,
        PrivilegedResourceUpdateRequest.JSON_PROPERTY_USER_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PrivilegedResourceUpdateRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public PrivilegedResourceUpdateRequest() {
    }

    /*
     * @JsonCreator public PrivilegedResourceUpdateRequest(
     *
     * @JsonProperty(JSON_PROPERTY_PROFILE) Map<String, Object> profile ) { this(); this.profile = profile; }
     */

    /**
     * Specific profile properties for the privileged account
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specific profile properties for the privileged account")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    public PrivilegedResourceUpdateRequest userName(String userName) {

        this.userName = userName;
        return this;
    }

    /**
     * The username associated with the privileged resource
     *
     * @return userName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "testuser@example.com", value = "The username associated with the privileged resource")
    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserName() {
        return userName;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedResourceUpdateRequest privilegedResourceUpdateRequest = (PrivilegedResourceUpdateRequest) o;
        return Objects.equals(this.profile, privilegedResourceUpdateRequest.profile)
                && Objects.equals(this.userName, privilegedResourceUpdateRequest.userName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(profile, userName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedResourceUpdateRequest {\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
