package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionSubjectConfirmation;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Provides a JSON representation of the &#x60;&lt;saml:Subject&gt;&#x60; element of the SAML assertion
 */
@ApiModel(description = "Provides a JSON representation of the `<saml:Subject>` element of the SAML assertion")
@JsonPropertyOrder({ SAMLPayLoadDataAssertionSubject.JSON_PROPERTY_NAME_ID,
        SAMLPayLoadDataAssertionSubject.JSON_PROPERTY_NAME_FORMAT,
        SAMLPayLoadDataAssertionSubject.JSON_PROPERTY_CONFIRMATION })
@JsonTypeName("SAMLPayLoad_data_assertion_subject")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadDataAssertionSubject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_NAME_ID = "nameId";
    private String nameId;

    public static final String JSON_PROPERTY_NAME_FORMAT = "nameFormat";
    private String nameFormat;

    public static final String JSON_PROPERTY_CONFIRMATION = "confirmation";
    private SAMLPayLoadDataAssertionSubjectConfirmation confirmation;

    public SAMLPayLoadDataAssertionSubject() {
    }

    public SAMLPayLoadDataAssertionSubject nameId(String nameId) {

        this.nameId = nameId;
        return this;
    }

    /**
     * The unique identifier of the user
     *
     * @return nameId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "user@example.com", value = "The unique identifier of the user")
    @JsonProperty(JSON_PROPERTY_NAME_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getNameId() {
        return nameId;
    }

    @JsonProperty(JSON_PROPERTY_NAME_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNameId(String nameId) {
        this.nameId = nameId;
    }

    public SAMLPayLoadDataAssertionSubject nameFormat(String nameFormat) {

        this.nameFormat = nameFormat;
        return this;
    }

    /**
     * Indicates how to interpret the attribute name
     *
     * @return nameFormat
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", value = "Indicates how to interpret the attribute name")
    @JsonProperty(JSON_PROPERTY_NAME_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getNameFormat() {
        return nameFormat;
    }

    @JsonProperty(JSON_PROPERTY_NAME_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    public SAMLPayLoadDataAssertionSubject confirmation(SAMLPayLoadDataAssertionSubjectConfirmation confirmation) {

        this.confirmation = confirmation;
        return this;
    }

    /**
     * Get confirmation
     *
     * @return confirmation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONFIRMATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataAssertionSubjectConfirmation getConfirmation() {
        return confirmation;
    }

    @JsonProperty(JSON_PROPERTY_CONFIRMATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConfirmation(SAMLPayLoadDataAssertionSubjectConfirmation confirmation) {
        this.confirmation = confirmation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertionSubject saMLPayLoadDataAssertionSubject = (SAMLPayLoadDataAssertionSubject) o;
        return Objects.equals(this.nameId, saMLPayLoadDataAssertionSubject.nameId)
                && Objects.equals(this.nameFormat, saMLPayLoadDataAssertionSubject.nameFormat)
                && Objects.equals(this.confirmation, saMLPayLoadDataAssertionSubject.confirmation);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameId, nameFormat, confirmation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertionSubject {\n");
        sb.append("    nameId: ").append(toIndentedString(nameId)).append("\n");
        sb.append("    nameFormat: ").append(toIndentedString(nameFormat)).append("\n");
        sb.append("    confirmation: ").append(toIndentedString(confirmation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
