package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.BaseContextSession;
import com.okta.sdk.resource.model.BaseContextUser;
import com.okta.sdk.resource.model.InlineHookRequestObject;
import com.okta.sdk.resource.model.SAMLPayLoadDataContextAllOfProtocol;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAMLPayLoadDataContext
 */
@JsonPropertyOrder({ SAMLPayLoadDataContext.JSON_PROPERTY_REQUEST, SAMLPayLoadDataContext.JSON_PROPERTY_SESSION,
        SAMLPayLoadDataContext.JSON_PROPERTY_USER, SAMLPayLoadDataContext.JSON_PROPERTY_PROTOCOL })
@JsonTypeName("SAMLPayLoad_data_context")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadDataContext implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_REQUEST = "request";
    private InlineHookRequestObject request;

    public static final String JSON_PROPERTY_SESSION = "session";
    private BaseContextSession session;

    public static final String JSON_PROPERTY_USER = "user";
    private BaseContextUser user;

    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private SAMLPayLoadDataContextAllOfProtocol protocol;

    public SAMLPayLoadDataContext() {
    }

    public SAMLPayLoadDataContext request(InlineHookRequestObject request) {

        this.request = request;
        return this;
    }

    /**
     * Get request
     *
     * @return request
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public InlineHookRequestObject getRequest() {
        return request;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequest(InlineHookRequestObject request) {
        this.request = request;
    }

    public SAMLPayLoadDataContext session(BaseContextSession session) {

        this.session = session;
        return this;
    }

    /**
     * Get session
     *
     * @return session
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextSession getSession() {
        return session;
    }

    @JsonProperty(JSON_PROPERTY_SESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSession(BaseContextSession session) {
        this.session = session;
    }

    public SAMLPayLoadDataContext user(BaseContextUser user) {

        this.user = user;
        return this;
    }

    /**
     * Get user
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextUser getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(BaseContextUser user) {
        this.user = user;
    }

    public SAMLPayLoadDataContext protocol(SAMLPayLoadDataContextAllOfProtocol protocol) {

        this.protocol = protocol;
        return this;
    }

    /**
     * Get protocol
     *
     * @return protocol
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROTOCOL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataContextAllOfProtocol getProtocol() {
        return protocol;
    }

    @JsonProperty(JSON_PROPERTY_PROTOCOL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProtocol(SAMLPayLoadDataContextAllOfProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataContext saMLPayLoadDataContext = (SAMLPayLoadDataContext) o;
        return Objects.equals(this.request, saMLPayLoadDataContext.request)
                && Objects.equals(this.session, saMLPayLoadDataContext.session)
                && Objects.equals(this.user, saMLPayLoadDataContext.user)
                && Objects.equals(this.protocol, saMLPayLoadDataContext.protocol);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(request, session, user, protocol);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataContext {\n");
        sb.append("    request: ").append(toIndentedString(request)).append("\n");
        sb.append("    session: ").append(toIndentedString(session)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("    protocol: ").append(toIndentedString(protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
