package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SAMLPayLoadDataContextAllOfProtocolIssuer;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details of the assertion protocol being used
 */
@ApiModel(description = "Details of the assertion protocol being used")
@JsonPropertyOrder({ SAMLPayLoadDataContextAllOfProtocol.JSON_PROPERTY_TYPE,
        SAMLPayLoadDataContextAllOfProtocol.JSON_PROPERTY_ISSUER })
@JsonTypeName("SAMLPayLoad_data_context_allOf_protocol")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadDataContextAllOfProtocol implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private SAMLPayLoadDataContextAllOfProtocolIssuer issuer;

    public SAMLPayLoadDataContextAllOfProtocol() {
    }

    public SAMLPayLoadDataContextAllOfProtocol type(String type) {

        this.type = type;
        return this;
    }

    /**
     * The type of authentication protocol being used for the assertion
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "SAML2.0", value = "The type of authentication protocol being used for the assertion")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public SAMLPayLoadDataContextAllOfProtocol issuer(SAMLPayLoadDataContextAllOfProtocolIssuer issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * Get issuer
     *
     * @return issuer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataContextAllOfProtocolIssuer getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(SAMLPayLoadDataContextAllOfProtocolIssuer issuer) {
        this.issuer = issuer;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataContextAllOfProtocol saMLPayLoadDataContextAllOfProtocol = (SAMLPayLoadDataContextAllOfProtocol) o;
        return Objects.equals(this.type, saMLPayLoadDataContextAllOfProtocol.type)
                && Objects.equals(this.issuer, saMLPayLoadDataContextAllOfProtocol.issuer);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, issuer);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataContextAllOfProtocol {\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
