package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The certificate that Okta uses to validate Single Logout (SLO) requests and responses
 */
@ApiModel(description = "The certificate that Okta uses to validate Single Logout (SLO) requests and responses")
@JsonPropertyOrder({ SamlSpCertificate.JSON_PROPERTY_X5C })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SamlSpCertificate implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_X5C = "x5c";
    private List<String> x5c = null;

    public SamlSpCertificate() {
    }

    public SamlSpCertificate x5c(List<String> x5c) {

        this.x5c = x5c;
        return this;
    }

    public SamlSpCertificate addx5cItem(String x5cItem) {
        if (this.x5c == null) {
            this.x5c = new ArrayList<>();
        }
        this.x5c.add(x5cItem);
        return this;
    }

    /**
     * A list that contains exactly one x509 encoded certificate
     *
     * @return x5c
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A list that contains exactly one x509 encoded certificate")
    @JsonProperty(JSON_PROPERTY_X5C)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getX5c() {
        return x5c;
    }

    @JsonProperty(JSON_PROPERTY_X5C)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlSpCertificate samlSpCertificate = (SamlSpCertificate) o;
        return Objects.equals(this.x5c, samlSpCertificate.x5c);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(x5c);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSpCertificate {\n");
        sb.append("    x5c: ").append(toIndentedString(x5c)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
