package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Federation Trust Credentials for verifying assertions from the IdP
 */
@ApiModel(description = "Federation Trust Credentials for verifying assertions from the IdP")
@JsonPropertyOrder({ SamlTrustCredentials.JSON_PROPERTY_AUDIENCE, SamlTrustCredentials.JSON_PROPERTY_ISSUER,
        SamlTrustCredentials.JSON_PROPERTY_KID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SamlTrustCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUDIENCE = "audience";
    private String audience;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public SamlTrustCredentials() {
    }

    public SamlTrustCredentials audience(String audience) {

        this.audience = audience;
        return this;
    }

    /**
     * URI that identifies the target Okta IdP instance (SP) for an &#x60;&lt;Assertion&gt;&#x60;
     *
     * @return audience
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://www.okta.com/saml2/service-provider/spgv32vOnpdyeGSaiUpL", value = "URI that identifies the target Okta IdP instance (SP) for an `<Assertion>`")
    @JsonProperty(JSON_PROPERTY_AUDIENCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAudience() {
        return audience;
    }

    @JsonProperty(JSON_PROPERTY_AUDIENCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAudience(String audience) {
        this.audience = audience;
    }

    public SamlTrustCredentials issuer(String issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * URI that identifies the issuer (IdP) of a &#x60;&lt;SAMLResponse&gt;&#x60; message &#x60;&lt;Assertion&gt;&#x60;
     * element
     *
     * @return issuer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "urn:example:idp", value = "URI that identifies the issuer (IdP) of a `<SAMLResponse>` message `<Assertion>` element")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SamlTrustCredentials kid(String kid) {

        this.kid = kid;
        return this;
    }

    /**
     * IdP Key Credential reference to the Okta X.509 signature certificate
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "your-key-id", value = "IdP Key Credential reference to the Okta X.509 signature certificate")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKid() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlTrustCredentials samlTrustCredentials = (SamlTrustCredentials) o;
        return Objects.equals(this.audience, samlTrustCredentials.audience)
                && Objects.equals(this.issuer, samlTrustCredentials.issuer)
                && Objects.equals(this.kid, samlTrustCredentials.kid);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(audience, issuer, kid);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlTrustCredentials {\n");
        sb.append("    audience: ").append(toIndentedString(audience)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
