package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SecurityEventTokenRequestJwtEvents;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * JSON Web Token body payload for a Security Event Token
 */
@ApiModel(description = "JSON Web Token body payload for a Security Event Token")
@JsonPropertyOrder({ SecurityEventTokenRequestJwtBody.JSON_PROPERTY_AUD,
        SecurityEventTokenRequestJwtBody.JSON_PROPERTY_EVENTS, SecurityEventTokenRequestJwtBody.JSON_PROPERTY_IAT,
        SecurityEventTokenRequestJwtBody.JSON_PROPERTY_ISS, SecurityEventTokenRequestJwtBody.JSON_PROPERTY_JTI })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SecurityEventTokenRequestJwtBody implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUD = "aud";
    private String aud;

    public static final String JSON_PROPERTY_EVENTS = "events";
    private SecurityEventTokenRequestJwtEvents events;

    public static final String JSON_PROPERTY_IAT = "iat";
    private Long iat;

    public static final String JSON_PROPERTY_ISS = "iss";
    private String iss;

    public static final String JSON_PROPERTY_JTI = "jti";
    private String jti;

    public SecurityEventTokenRequestJwtBody() {
    }

    public SecurityEventTokenRequestJwtBody aud(String aud) {

        this.aud = aud;
        return this;
    }

    /**
     * Audience
     *
     * @return aud
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://receiverexample.okta.com/", required = true, value = "Audience")
    @JsonProperty(JSON_PROPERTY_AUD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAud() {
        return aud;
    }

    @JsonProperty(JSON_PROPERTY_AUD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAud(String aud) {
        this.aud = aud;
    }

    public SecurityEventTokenRequestJwtBody events(SecurityEventTokenRequestJwtEvents events) {

        this.events = events;
        return this;
    }

    /**
     * Get events
     *
     * @return events
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_EVENTS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SecurityEventTokenRequestJwtEvents getEvents() {
        return events;
    }

    @JsonProperty(JSON_PROPERTY_EVENTS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEvents(SecurityEventTokenRequestJwtEvents events) {
        this.events = events;
    }

    public SecurityEventTokenRequestJwtBody iat(Long iat) {

        this.iat = iat;
        return this;
    }

    /**
     * Token issue time (UNIX timestamp)
     *
     * @return iat
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "1702448550", required = true, value = "Token issue time (UNIX timestamp)")
    @JsonProperty(JSON_PROPERTY_IAT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Long getIat() {
        return iat;
    }

    @JsonProperty(JSON_PROPERTY_IAT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setIat(Long iat) {
        this.iat = iat;
    }

    public SecurityEventTokenRequestJwtBody iss(String iss) {

        this.iss = iss;
        return this;
    }

    /**
     * Token issuer
     *
     * @return iss
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://transmitter.example.com", required = true, value = "Token issuer")
    @JsonProperty(JSON_PROPERTY_ISS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getIss() {
        return iss;
    }

    @JsonProperty(JSON_PROPERTY_ISS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setIss(String iss) {
        this.iss = iss;
    }

    public SecurityEventTokenRequestJwtBody jti(String jti) {

        this.jti = jti;
        return this;
    }

    /**
     * Token ID
     *
     * @return jti
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "24c63fb56f ... a9fa24", required = true, value = "Token ID")
    @JsonProperty(JSON_PROPERTY_JTI)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getJti() {
        return jti;
    }

    @JsonProperty(JSON_PROPERTY_JTI)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setJti(String jti) {
        this.jti = jti;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventTokenRequestJwtBody securityEventTokenRequestJwtBody = (SecurityEventTokenRequestJwtBody) o;
        return Objects.equals(this.aud, securityEventTokenRequestJwtBody.aud)
                && Objects.equals(this.events, securityEventTokenRequestJwtBody.events)
                && Objects.equals(this.iat, securityEventTokenRequestJwtBody.iat)
                && Objects.equals(this.iss, securityEventTokenRequestJwtBody.iss)
                && Objects.equals(this.jti, securityEventTokenRequestJwtBody.jti);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(aud, events, iat, iss, jti);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventTokenRequestJwtBody {\n");
        sb.append("    aud: ").append(toIndentedString(aud)).append("\n");
        sb.append("    events: ").append(toIndentedString(events)).append("\n");
        sb.append("    iat: ").append(toIndentedString(iat)).append("\n");
        sb.append("    iss: ").append(toIndentedString(iss)).append("\n");
        sb.append("    jti: ").append(toIndentedString(jti)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
