package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEvent;
import com.okta.sdk.resource.model.CaepSessionRevokedEvent;
import com.okta.sdk.resource.model.OktaDeviceRiskChangeEvent;
import com.okta.sdk.resource.model.OktaIpChangeEvent;
import com.okta.sdk.resource.model.OktaUserRiskChangeEvent;
import com.okta.sdk.resource.model.RiscIdentifierChangedEvent;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A non-empty collection of events
 */
@ApiModel(description = "A non-empty collection of events")
@JsonPropertyOrder({
        SecurityEventTokenRequestJwtEvents.JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_DEVICE_RISK_CHANGE,
        SecurityEventTokenRequestJwtEvents.JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_IP_CHANGE,
        SecurityEventTokenRequestJwtEvents.JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_USER_RISK_CHANGE,
        SecurityEventTokenRequestJwtEvents.JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_CAEP_EVENT_TYPE_DEVICE_COMPLIANCE_CHANGE,
        SecurityEventTokenRequestJwtEvents.JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_CAEP_EVENT_TYPE_SESSION_REVOKED,
        SecurityEventTokenRequestJwtEvents.JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_RISC_EVENT_TYPE_IDENTIFIER_CHANGED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SecurityEventTokenRequestJwtEvents implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_DEVICE_RISK_CHANGE = "https://schemas.okta.com/secevent/okta/event-type/device-risk-change";
    private OktaDeviceRiskChangeEvent httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange;

    public static final String JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_IP_CHANGE = "https://schemas.okta.com/secevent/okta/event-type/ip-change";
    private OktaIpChangeEvent httpsSchemasOktaComSeceventOktaEventTypeIpChange;

    public static final String JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_USER_RISK_CHANGE = "https://schemas.okta.com/secevent/okta/event-type/user-risk-change";
    private OktaUserRiskChangeEvent httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange;

    public static final String JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_CAEP_EVENT_TYPE_DEVICE_COMPLIANCE_CHANGE = "https://schemas.openid.net/secevent/caep/event-type/device-compliance-change";
    private CaepDeviceComplianceChangeEvent httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange;

    public static final String JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_CAEP_EVENT_TYPE_SESSION_REVOKED = "https://schemas.openid.net/secevent/caep/event-type/session-revoked";
    private CaepSessionRevokedEvent httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked;

    public static final String JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_RISC_EVENT_TYPE_IDENTIFIER_CHANGED = "https://schemas.openid.net/secevent/risc/event-type/identifier-changed";
    private RiscIdentifierChangedEvent httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged;

    public SecurityEventTokenRequestJwtEvents() {
    }

    public SecurityEventTokenRequestJwtEvents httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange(
            OktaDeviceRiskChangeEvent httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange) {

        this.httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange = httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange;
        return this;
    }

    /**
     * Get httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange
     *
     * @return httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_DEVICE_RISK_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OktaDeviceRiskChangeEvent getHttpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange() {
        return httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange;
    }

    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_DEVICE_RISK_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHttpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange(
            OktaDeviceRiskChangeEvent httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange) {
        this.httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange = httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange;
    }

    public SecurityEventTokenRequestJwtEvents httpsSchemasOktaComSeceventOktaEventTypeIpChange(
            OktaIpChangeEvent httpsSchemasOktaComSeceventOktaEventTypeIpChange) {

        this.httpsSchemasOktaComSeceventOktaEventTypeIpChange = httpsSchemasOktaComSeceventOktaEventTypeIpChange;
        return this;
    }

    /**
     * Get httpsSchemasOktaComSeceventOktaEventTypeIpChange
     *
     * @return httpsSchemasOktaComSeceventOktaEventTypeIpChange
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_IP_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OktaIpChangeEvent getHttpsSchemasOktaComSeceventOktaEventTypeIpChange() {
        return httpsSchemasOktaComSeceventOktaEventTypeIpChange;
    }

    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_IP_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHttpsSchemasOktaComSeceventOktaEventTypeIpChange(
            OktaIpChangeEvent httpsSchemasOktaComSeceventOktaEventTypeIpChange) {
        this.httpsSchemasOktaComSeceventOktaEventTypeIpChange = httpsSchemasOktaComSeceventOktaEventTypeIpChange;
    }

    public SecurityEventTokenRequestJwtEvents httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange(
            OktaUserRiskChangeEvent httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange) {

        this.httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange = httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange;
        return this;
    }

    /**
     * Get httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange
     *
     * @return httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_USER_RISK_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OktaUserRiskChangeEvent getHttpsSchemasOktaComSeceventOktaEventTypeUserRiskChange() {
        return httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange;
    }

    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OKTA_COM_SECEVENT_OKTA_EVENT_TYPE_USER_RISK_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHttpsSchemasOktaComSeceventOktaEventTypeUserRiskChange(
            OktaUserRiskChangeEvent httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange) {
        this.httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange = httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange;
    }

    public SecurityEventTokenRequestJwtEvents httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange(
            CaepDeviceComplianceChangeEvent httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange) {

        this.httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange = httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange;
        return this;
    }

    /**
     * Get httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange
     *
     * @return httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_CAEP_EVENT_TYPE_DEVICE_COMPLIANCE_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CaepDeviceComplianceChangeEvent getHttpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange() {
        return httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange;
    }

    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_CAEP_EVENT_TYPE_DEVICE_COMPLIANCE_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHttpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange(
            CaepDeviceComplianceChangeEvent httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange) {
        this.httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange = httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange;
    }

    public SecurityEventTokenRequestJwtEvents httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked(
            CaepSessionRevokedEvent httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked) {

        this.httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked = httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked;
        return this;
    }

    /**
     * Get httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked
     *
     * @return httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_CAEP_EVENT_TYPE_SESSION_REVOKED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CaepSessionRevokedEvent getHttpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked() {
        return httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked;
    }

    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_CAEP_EVENT_TYPE_SESSION_REVOKED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHttpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked(
            CaepSessionRevokedEvent httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked) {
        this.httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked = httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked;
    }

    public SecurityEventTokenRequestJwtEvents httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged(
            RiscIdentifierChangedEvent httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged) {

        this.httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged = httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged;
        return this;
    }

    /**
     * Get httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged
     *
     * @return httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_RISC_EVENT_TYPE_IDENTIFIER_CHANGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RiscIdentifierChangedEvent getHttpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged() {
        return httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged;
    }

    @JsonProperty(JSON_PROPERTY_HTTPS_SCHEMAS_OPENID_NET_SECEVENT_RISC_EVENT_TYPE_IDENTIFIER_CHANGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHttpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged(
            RiscIdentifierChangedEvent httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged) {
        this.httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged = httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventTokenRequestJwtEvents securityEventTokenRequestJwtEvents = (SecurityEventTokenRequestJwtEvents) o;
        return Objects.equals(this.httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange,
                securityEventTokenRequestJwtEvents.httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange)
                && Objects.equals(this.httpsSchemasOktaComSeceventOktaEventTypeIpChange,
                        securityEventTokenRequestJwtEvents.httpsSchemasOktaComSeceventOktaEventTypeIpChange)
                && Objects.equals(this.httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange,
                        securityEventTokenRequestJwtEvents.httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange)
                && Objects.equals(this.httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange,
                        securityEventTokenRequestJwtEvents.httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange)
                && Objects.equals(this.httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked,
                        securityEventTokenRequestJwtEvents.httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked)
                && Objects.equals(this.httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged,
                        securityEventTokenRequestJwtEvents.httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange,
                httpsSchemasOktaComSeceventOktaEventTypeIpChange,
                httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange,
                httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange,
                httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked,
                httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventTokenRequestJwtEvents {\n");
        sb.append("    httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange: ")
                .append(toIndentedString(httpsSchemasOktaComSeceventOktaEventTypeDeviceRiskChange)).append("\n");
        sb.append("    httpsSchemasOktaComSeceventOktaEventTypeIpChange: ")
                .append(toIndentedString(httpsSchemasOktaComSeceventOktaEventTypeIpChange)).append("\n");
        sb.append("    httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange: ")
                .append(toIndentedString(httpsSchemasOktaComSeceventOktaEventTypeUserRiskChange)).append("\n");
        sb.append("    httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange: ")
                .append(toIndentedString(httpsSchemasOpenidNetSeceventCaepEventTypeDeviceComplianceChange))
                .append("\n");
        sb.append("    httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked: ")
                .append(toIndentedString(httpsSchemasOpenidNetSeceventCaepEventTypeSessionRevoked)).append("\n");
        sb.append("    httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged: ")
                .append(toIndentedString(httpsSchemasOpenidNetSeceventRiscEventTypeIdentifierChanged)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
