package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Security Events Provider settings
 */
@ApiModel(description = "Security Events Provider settings")
@JsonPropertyOrder({ SecurityEventsProviderSettingsResponse.JSON_PROPERTY_ISSUER,
        SecurityEventsProviderSettingsResponse.JSON_PROPERTY_JWKS_URL,
        SecurityEventsProviderSettingsResponse.JSON_PROPERTY_WELL_KNOWN_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SecurityEventsProviderSettingsResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;

    public static final String JSON_PROPERTY_JWKS_URL = "jwks_url";
    private String jwksUrl;

    public static final String JSON_PROPERTY_WELL_KNOWN_URL = "well_known_url";
    private JsonNullable<String> wellKnownUrl = JsonNullable.<String> undefined();

    public SecurityEventsProviderSettingsResponse() {
    }

    public SecurityEventsProviderSettingsResponse issuer(String issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * Issuer URL
     *
     * @return issuer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "example.okta.com", value = "Issuer URL")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SecurityEventsProviderSettingsResponse jwksUrl(String jwksUrl) {

        this.jwksUrl = jwksUrl;
        return this;
    }

    /**
     * The public URL where the JWKS public key is uploaded
     *
     * @return jwksUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://example.okta.com/oauth2/v1/keys", value = "The public URL where the JWKS public key is uploaded")
    @JsonProperty(JSON_PROPERTY_JWKS_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getJwksUrl() {
        return jwksUrl;
    }

    @JsonProperty(JSON_PROPERTY_JWKS_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public SecurityEventsProviderSettingsResponse wellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = JsonNullable.<String> of(wellKnownUrl);

        return this;
    }

    /**
     * The well-known URL of the Security Events Provider (the SSF transmitter)
     *
     * @return wellKnownUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://example.okta.com/.well-known/ssf-configuration", value = "The well-known URL of the Security Events Provider (the SSF transmitter)")
    @JsonIgnore

    public String getWellKnownUrl() {
        return wellKnownUrl.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_WELL_KNOWN_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getWellKnownUrl_JsonNullable() {
        return wellKnownUrl;
    }

    @JsonProperty(JSON_PROPERTY_WELL_KNOWN_URL)
    public void setWellKnownUrl_JsonNullable(JsonNullable<String> wellKnownUrl) {
        this.wellKnownUrl = wellKnownUrl;
    }

    public void setWellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = JsonNullable.<String> of(wellKnownUrl);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderSettingsResponse securityEventsProviderSettingsResponse = (SecurityEventsProviderSettingsResponse) o;
        return Objects.equals(this.issuer, securityEventsProviderSettingsResponse.issuer)
                && Objects.equals(this.jwksUrl, securityEventsProviderSettingsResponse.jwksUrl)
                && equalsNullable(this.wellKnownUrl, securityEventsProviderSettingsResponse.wellKnownUrl);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(issuer, jwksUrl, hashCodeNullable(wellKnownUrl));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderSettingsResponse {\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    jwksUrl: ").append(toIndentedString(jwksUrl)).append("\n");
        sb.append("    wellKnownUrl: ").append(toIndentedString(wellKnownUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
